<?php

// Pre-requisites
$nestedLocation = '../../';
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
$pageTitle = 'Contact Page';
$pageName = 'Contact';
$pageType = 0;

// Auto load classes
include($nestedLocation . 'resources/includes/class-autoload.inc.php');

// Initial API Instance for aafran (2) - This populates the location dropdown
$locationsAPI = new API(2);

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title><?php echo $pageTitle; ?></title>
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>

    <script>
      (function () {
        window.onload = function () {
          var preloader = document.querySelector('.page-loading');
          preloader.classList.remove('active');
          setTimeout(function () {
            preloader.remove();
          }, 2000);
        };
      })();
    </script>
    
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Sign In Modal-->
      <?php include_once($nestedLocation . 'resources/layouts/sign-in-modal.layout.php'); ?>

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->

      <!-- Property cost calculator modal-->
      <?php include_once($nestedLocation . 'resources/layouts/modals/calculator.layout.php'); ?>

      <!-- Rent my home modal-->
      <?php include_once($nestedLocation . 'resources/layouts/modals/rmh.layout.php'); ?>

      <!-- Breadcrumb-->
      <div class="container mt-5 mb-md-4 pt-5">
        <nav class="mb-3 pt-md-3" aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="real-estate-home-v1.html">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Contact us</li>
          </ol>
        </nav>
      </div>
      <!-- Hero-->
      <section class="container mb-5 pb-2 pb-md-4 pb-lg-5">
        <div class="row my-4 px-0">
          <div class="col-12">
            <div class="alert alert-primary" role="alert">
              <b>Heads up!</b>
              <br><br>
              You are contacting the Home Office for All County Franchise. If this is in regards to renting/managing/maintenance of a home/apartment please visit your local office's page to get in touch with them directly. This is the fastest way to receive a response.
            </div>
          </div>
        </div>
        <div class="row align-items-md-start align-items-center gy-4">
          <div class="col-lg-5 col-md-6">
            <div class="mx-md-0 mx-auto mb-md-5 mb-4 pb-md-4 text-md-start text-center" style="max-width: 416px;">
              <h1 class="mb-4">Get in touch!</h1>
              <p class="mb-0 fs-lg text-muted">Fill out the form and out team will try to get back to you within 24 hours.</p>
            </div><img class="d-block mx-auto" src="<?php echo $nestedLocation; ?>resources/img/real-estate/illustrations/contact.svg" alt="Illustration">
          </div>
          <div class="col-md-6 offset-lg-1">
            <div class="card border-0 bg-secondary p-sm-3 p-2">
              <div class="card-body m-1">
                <form class="needs-validation" novalidate>
                  <div class="mb-4">
                    <label class="form-label" for="c-name">Full Name</label>
                    <input class="form-control form-control-lg" id="c-name" type="text" required>
                    <div class="invalid-tooltip mt-1">Please, enter your name</div>
                  </div>
                  <div class="row">
                    <div class="col-6">
                      <div class="mb-4">
                        <label class="form-label" for="c-email">Your Email</label>
                        <input class="form-control form-control-lg" id="c-email" type="email" required>
                        <div class="invalid-tooltip mt-1">Please, enter your email</div>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="mb-4">
                        <label class="form-label" for="c-email">Your Phone</label>
                        <input class="form-control form-control-lg" id="c-phone" type="phone" required>
                        <div class="invalid-tooltip mt-1">Please, enter your phone</div>
                      </div>
                    </div>
                  </div>
                  <div class="mb-4">
                    <label class="form-label" for="c-message">Message</label>
                    <textarea class="form-control form-control-lg" id="c-message" rows="4" placeholder="Leave your message" required></textarea>
                    <div class="invalid-tooltip mt-1">Please, type your message</div>
                  </div>
                  <div class="pt-sm-2 pt-1">
                    <button class="btn btn-lg btn-primary btn-block w-100" type="submit">Send</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </section>
      <!-- Contact cards-->
      <section class="container mb-5 pb-2 pb-md-4 pb-lg-5">
        <div class="row g-4">
          <!-- Item-->
          <div class="col-md-4"><a class="icon-box card card-hover h-100" href="mailto:example@email.com">
              <div class="card-body">
                <div class="icon-box-media text-primary rounded-circle shadow-sm mb-3"><i class="fi-mail"></i></div><span class="d-block mb-1 text-body">Drop us a line</span>
                <h3 class="h4 icon-box-title mb-0 opacity-90">contact@allcountyprop.com</h3>
              </div></a></div>
          <!-- Item-->
          <div class="col-md-4"><a class="icon-box card card-hover h-100" href="tel:7278003700">
              <div class="card-body">
                <div class="icon-box-media text-primary rounded-circle shadow-sm mb-3"><i class="fi-device-mobile"></i></div><span class="d-block mb-1 text-body">Call us any time</span>
                <h3 class="h4 icon-box-title mb-0 opacity-90">(727) 800-3700</h3>
              </div></a></div>
          <!-- Item-->
          <div class="col-md-4"><a class="icon-box card card-hover h-100" href="#">
              <div class="card-body">
                <div class="icon-box-media text-primary rounded-circle shadow-sm mb-3"><i class="fi-instagram"></i></div><span class="d-block mb-1 text-body">Follow us</span>
                <h3 class="h4 icon-box-title mb-0 opacity-90">@allcountyprop</h3>
              </div></a></div>
        </div>
      </section>

      <!-- CTA-->
      <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>
  </body>
</html>