<?php
// Inject CORE
$nestedLocation = '';
include($nestedLocation . 'resources/includes/core/acpm/home/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- INC/LAYOUT - Head -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
  </head>
  <body>
    
    <!-- INC/LAYOUT - Page Loader & GTM-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- INC/LAYOUT - Navigation Bar -->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->

      <!-- Hero-->
      <section class="container pt-5 my-5 pb-lg-5" id="header">
        <div class="row pt-0 pt-md-2 pt-lg-0">
          <div class="col-xl-7 col-lg-6 col-md-5 order-md-2 mb-4 mb-lg-3"><img src="<?php echo $nestedLocation; ?>resources/img/acprop/home/banner-home.jpg" alt="Hero image"></div>
          <div class="col-xl-5 col-lg-6 col-md-7 order-md-1 pt-xl-1 pe-lg-0 mb-3 text-md-start text-center">
            <h1 class="display-4 mt-lg-3 mb-md-4 mb-3 pt-md-4 pb-lg-2" style="word-spacing: 100vw;">Dear Property Owners,</h1>
            <p class="position-relative lead me-lg-n5 text-primary">Owning rental properties just got easier!</p>
            <p class="position-relative lead me-lg-n5">We manage residential properties by using proven methods that make owning rental properties more profitable. To get started, search below to connect with your local All County property management expert.</p>
          </div>
          <!-- Search property form group-->
          <div class="col-xl-6 col-lg-8 order-3 mt-lg-n5">
            <form class="form-group d-block d-md-flex position-relative me-lg-n5" action="locations/" method="get">
                <div class="input-group input-group-lg border-end-md"><span class="input-group-text text-muted rounded-pill ps-3"><i class="fi-map-pin mx-2"></i></span>
                  <input class="form-control" required id="address" name="address" type="text" placeholder="Enter your zip code" pattern="^\s*?\d{5}(?:[-\s]\d{4})?\s*?$">
                </div>
                <hr class="d-md-none my-2">
                <div class="d-sm-flex">
                  <button class="btn btn-primary btn-lg w-100 w-md-auto ms-sm-3" type="submit" >Find a Property Manager</button>
                </div>
              </form>
          </div>
        </div>
      </section>

      <!-- States We Service -->
      <section class="container mb-5 pb-lg-5" id="statesWeService">
        <div class="d-flex align-items-center justify-content-between mb-3">
          <h2 class="h3 mb-3">Or select a state to get started.</h2>
          <a class="btn btn-link fw-normal p-0 d-none" href="locations/">View all<i class="fi-arrow-long-right ms-2"></i></a>
        </div>
        <div class="row row-cols-lg-6 row-cols-sm-3 row-cols-2 g-3 g-xl-4">
          <div class="col"><a class="icon-box card card-body h-100 border-0 shadow-sm card-hover h-100 text-center" href="locations/florida">
              <div class="icon-box-media bg-faded-primary text-primary rounded-circle mb-3 mx-auto">FL</div>
              <h3 class="icon-box-title fs-base mb-0">Florida Property Management</h3></a></div>
          <div class="col"><a class="icon-box card card-body h-100 border-0 shadow-sm card-hover h-100 text-center" href="locations/california">
              <div class="icon-box-media bg-faded-primary text-primary rounded-circle mb-3 mx-auto">CA</div>
              <h3 class="icon-box-title fs-base mb-0">California Property Management</h3></a></div>
          <div class="col"><a class="icon-box card card-body h-100 border-0 shadow-sm card-hover h-100 text-center" href="locations/texas">
              <div class="icon-box-media bg-faded-primary text-primary rounded-circle mb-3 mx-auto">TX</div>
              <h3 class="icon-box-title fs-base mb-0">Texas Property Management</h3></a></div>
          <div class="col"><a class="icon-box card card-body h-100 border-0 shadow-sm card-hover h-100 text-center" href="locations/colorado">
              <div class="icon-box-media bg-faded-primary text-primary rounded-circle mb-3 mx-auto">CO</div>
              <h3 class="icon-box-title fs-base mb-0">Colorado Property Management</h3></a></div>
          <div class="col"><a class="icon-box card card-body h-100 border-0 shadow-sm card-hover h-100 text-center" href="locations/georgia">
              <div class="icon-box-media bg-faded-primary text-primary rounded-circle mb-3 mx-auto">GA</div>
              <h3 class="icon-box-title fs-base mb-0">Georgia Property Management</h3></a></div>
          <div class="col"><a class="icon-box card card-body h-100 border-0 shadow-sm card-hover h-100 text-center" href="locations/states/">
              <div class="icon-box-media bg-faded-primary text-primary rounded-circle mb-3 mx-auto">+</div>
              <h3 class="icon-box-title fs-base mb-0">View all states</h3></a></div>
        </div>
      </section>

      <!-- All County Reviews -->
      <hr>
      <section class="container mt-5 mb-5" id="aboutAllCounty">
        <h1 class="h1 mb-1">Reviews</h1>
        <h5 class="mb-4 text-accent">Take a look at what home owners are saying about us!</h5>

        <div class="tns-carousel-wrapper tns-nav-outside tns-nav-outside-flush mx-n2 bg-secondary rounded-3">
          <div class="tns-carousel-inner row gx-4 mx-0 py-3" data-carousel-options="{&quot;items&quot;: 2, &quot;controls&quot;: false, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:1},&quot;768&quot;:{&quot;items&quot;:2}}}">
            <div class="col">
              <div class="card card-hover border-0 h-100 pb-2 pb-sm-3 px-sm-3">
                <div class="card-body">
                  <h2 class="h4 card-title">John P.</h2>
                  <small class="text-primary">with All County Cowboy Property Management</small>
                  <br><br>
                  <p class="card-text fs-sm">
                    We took over managing an apartment complex for my aging father and quickly realized that we lacked the experience and time and expertise to manage our apartments. We needed professional help!<br><br>
                    Enter Tom and his crew from All County® Cowboy Property Management. They’ve gone above and beyond to make sure that our family’s apartment complex and all of its issues from a broken water heater that flooded two apartments to deferred maintenance were addressed promptly and as quickly as possible.<br><br>
                    From renting an apartment to rehabilitating an apartement when tenants move out, it's great to have a partner like All County® Cowboy Property. We can sleep better knowing Tom and his staff will field any late-night trouble calls. They take care of most normal maintenance too, maintaining our property properly.<br><br>
                    And All County® Cowboy Property emails me a monthly cash-flow statement too. This is peace of mind is priceless for me and my family, plus I'm glad that our tenants are able to live and work comfortably!
                    If you have one or more properties in Laramie, call All County® Cowboy Property Management today!
                  </p>
                </div>
              </div>
            </div>
            <div class="col">
              <div class="card card-hover border-0 h-100 pb-2 pb-sm-3 px-sm-3">
                <div class="card-body">
                  <h2 class="h4 card-title">Nickle L.</h2>
                  <small class="text-primary">with All County Premier Property Management</small>
                  <br><br>
                  <p class="card-text fs-sm">
                    I have had the pleasure of working with All County Premier for several years now, and I can honestly say that they have consistently exceeded my expectations. From the very beginning, they were patient and thorough in explaining their process and helping me navigate the complexities of managing a rental property.<br><br>
                    One of the things I appreciate most about All County Premier is their attention to detail. They are extremely organized and always make sure to follow up on any questions or concerns I have. They are also great at keeping me informed about the status of my property and any issues that may arise.<br><br>
                    I have always felt confident in their to handle any situation that comes up, and they have always been quick to resolve any issues that have come up.<br><br>
                    I have had a great experience working with them, and I am looking forward to a long and successful collaboration with them. They have truly made the process of managing a rental property a breeze, and I highly recommend them to any homeowner looking for a reliable and trustworthy property management company.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>


      <!-- About All County -->
      <hr>
      <section class="container mt-5 mb-5" id="aboutAllCounty">
        <div class="row align-items-center justify-content-center">
          <!-- Hero content-->
          <div class="col-lg-4 col-md-5 col-sm-9 order-md-1 order-2 text-md-start text-center">
            <h1 class="mb-1">Who we are.</h1>
            <h5 class="mb-4 text-accent">All County Property Management</h5>
            <p class="mb-4 pb-3 fs-lg">At All County® we believe in doing business the smart way, building relationships, and investing for the future. We do this by being the best professionals in our field, focusing on the long-term goals, providing excellent customer service for our property owners and tenants and exceeding expectations.</p>
            <a class="btn btn-lg btn-primary" href="about/">Learn more</a>
          </div>
          <!-- Hero carousel-->
          <div class="col-lg-7 col-md-6 offset-md-1 col-12 order-md-2 order-1">
            <div style="padding:65.25% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/647823529?h=1896658e0e&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;" title="A Conversation with CEO Sandy Ferrera"></iframe></div><script src="https://player.vimeo.com/api/player.js"></script></div>
        </div>
        <div class="tns-carousel-wrapper tns-nav-outside tns-nav-outside-flush mx-n2">
          <div class="tns-carousel-inner row gx-4 mx-0 py-3" data-carousel-options="{&quot;items&quot;: 3, &quot;controls&quot;: false, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:2},&quot;768&quot;:{&quot;items&quot;:3}}}">
            <div class="col">
              <div class="card card-hover border-0 h-100 pb-2 pb-sm-3 px-sm-3 text-center"><img class="d-block mx-auto my-3" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/sell.svg" width="256" alt="Illustration">
                <div class="card-body">
                  <h2 class="h4 card-title">Property Mangement</h2>
                  <p class="card-text fs-sm">Looking to rent your home? Our professional team of Property Managers is here to guide you through the entire process, let us take care of your most valuable asset!</p>
                </div>
                <div class="card-footer pt-0 border-0"><a class="btn btn-outline-primary stretched-link" href="<?php echo $nestedLocation; ?>locations/">Find an office</a></div>
              </div>
            </div>
            <div class="col">
              <div class="card card-hover border-0 h-100 pb-2 pb-sm-3 px-sm-3 text-center"><img class="d-block mx-auto my-3" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/rent.svg" width="256" alt="Illustration">
                <div class="card-body">
                  <h2 class="h4 card-title">Available Rentals</h2>
                  <p class="card-text fs-sm">Looking for a rental? All County has rentals available nationwide, click below to find a location nearest to you and see their available rentals.</p>
                </div>
                <div class="card-footer pt-0 border-0"><a class="btn btn-outline-primary stretched-link" href="<?php echo $nestedLocation; ?>locations/">Find an office</a></div>
              </div>
            </div>
            <div class="col">
              <div class="card card-hover border-0 h-100 pb-2 pb-sm-3 px-sm-3 text-center"><img class="d-block mx-auto my-3" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/buy.svg" width="256" alt="Illustration">
                <div class="card-body">
                  <h2 class="h4 card-title">Need Help</h2>
                  <p class="card-text fs-sm">Our team is here to help you with whatever questions you may have about your rental.</p>
                </div>
                <div class="card-footer pt-0 border-0"><a class="btn btn-outline-primary stretched-link" href="<?php echo $nestedLocation; ?>locations/">Find an office</a></div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Why choose us -->
      <hr>
      <section class="container mb-5 mt-5 pb-lg-4 pb-2 pb-sm-3" id="whyPartnerWithUs">
        <h1 class="h1 mb-1">Why partner with us.</h1>
        <h5 class="mb-4 text-accent">Best rates, transparency, and knowledge.</h5>
        <p>With over three decades in this business, we are the professional experts in long term residential. We are client focused and handle all aspects of your property, ensuring you peace of mind that your asset is performing to its fullest potential.</p>
        <div class="row gy-4 mt-4">
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch pe-lg-4">
            <div class="card">
              <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/client-focused.png" alt="Business professionals discussing marketing tactics.">
              <div class="card-header text-center text-primary pb-0">
                <h6>Client Focused</h6>
              </div>
              <div class="card-body">
                <p class="mb-4 pb-md-3 opacity-70">
                  We specialize in long-term residential housing. We have over three decades in this business, we know being focused in one area gets a better return on your investment. We handle all aspects of your property, ensuring you peace of mind that your asset is performing to its fullest potential.
                </p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch pe-lg-4">
            <div class="card">
              <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/best-rates.png" alt="Jolly individual sitting down on couch.">
              <div class="card-header text-center text-primary pb-0">
                <h6>Best Rates</h6>
              </div>
              <div class="card-body">
                <p class="mb-4 pb-md-3 opacity-70">
                  Our experts evaluate your property to get you the best rental rates. We place quality tenants and maintain your asset, so it continues to grow. Our owner pricing is straight forward, there are no hidden fees, no additional charges for maintenance and we only make money when you make money.
                </p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch">
            <div class="card">
              <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/knowledge.png" alt="Realtor discussing options with client.">
              <div class="card-header text-center text-primary pb-0">
                <h6>Knowledge</h6>
              </div>
              <div class="card-body">
                <p class="mb-4 pb-md-3 opacity-70">
                  With over 30 years specializing in residential property management and offices throughout the U.S. are property managers are the best in their field. Their vast knowledge will help you avoid costly issues and ensure that your property maximizes your return.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Everything you need -->
      <hr>
      <section class="container mt-5">
        <div class="d-flex align-items-center justify-content-center text-center">
          <h2 class="h2 mb-3 text-primary fw-bold"><i><b>All County Gives You Everything You Need<br>To Suceed In Real Estate Investment!</b></i></h2>
        </div>
        <p class="text-center">We have been operating more than 30 years and understand what it takes to make the most money from your rental.</p>
        <div class="row pt-5">
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0">
                <i class="fi-rent mb-4 display-6 text-primary"></i>
                <br>
                Comprehensive advertising
              </div>
              <div class="card-body">
                <p>Our goal is to reach all of the applicants looking for your property.</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0">
                <i class="fi-user-check mb-4 display-6 text-primary"></i>
                <br>Tenant placement
              </div>
              <div class="card-body">
                <p>Let us take the hassle out of finding and placing. We will make sure a quality tenant is living in your property.</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0"><i class="fi-file mb-4 display-6 text-primary"></i><br>Lease preparation and negotiation</div>
              <div class="card-body">
                <p>Our qualified team creates and executes all leases with detail as well as care.</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0"><i class="fi-security mb-4 display-6 text-primary"></i><br>Lease compliance</div>
              <div class="card-body">
                <p>Our team of attorneys keep our documents and procedures up to date for everyone's safety.</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0"><i class="fi-cash mb-4 display-6 text-primary"></i><br>Rigorous collection practices</div>
              <div class="card-body">
                <p>Having convenient online payment options and partnerships with companies who process money orders directly to residents ledgers.</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0"><i class="fi-truck mb-4 display-6 text-primary"></i><br>Maintenance coordination</div>
              <div class="card-body">
                <p>Better response time and cost to you have been built because of our vendor relationships</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0"><i class="fi-home mb-4 display-6 text-primary"></i><br>Regular inspections</div>
              <div class="card-body">
                <p>Make sure your most valuable assets has our team watching over.</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0"><i class="fi-briefcase mb-4 display-6 text-primary"></i><br>Easy reporting</div>
              <div class="card-body">
                <p>Our robust system makes it easy to visualize your investments via easy to read reports.</p>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
          <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
            <div class="card w-100 text-center border-0">
              <div class="card-header h5 border-0"><i class="fi-plus mb-4 display-6 text-primary"></i><br>And Much More!</div>
              <div class="card-body">
                <button class="btn btn-outline-primary p-3">View all the services we offer <i class="fi-arrow-right ms-3"></i></button>
              </div>
              <!-- <div class="card-footer border-0">
                <div class="btn btn-sm text-black btn-secondary">Learn more</div>
              </div> -->
            </div>
          </div>
        </div>
      </section>

      <!-- PM's-->
      <hr>
      <?php include_once($nestedLocation . 'resources/layouts/widgets/pms.layout.php'); ?>
      
      <!-- CTA-->
      <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

  </body>
</html>