<?php
$nestedLocation = '../../../';

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// Include sendgrid
require_once($nestedLocation . '../../../' . 'resources/external/vendor/SendGrid/sendgrid-php.php');

use SendGrid\Mail\Mail;

// Your secret key
$recaptcha_secret = '6Le5EswqAAAAABc2stVjM0iumF1Sw0zbB3Uw_vSM';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $recaptcha_response = $_POST['g-recaptcha-response'] ?? '';

    // Verify reCAPTCHA
    $verify_url = 'https://www.google.com/recaptcha/api/siteverify';
    $response = file_get_contents("$verify_url?secret=$recaptcha_secret&response=$recaptcha_response");
    $response_keys = json_decode($response, true);

    if (!$response_keys["success"] || $response_keys["score"] < 0.5) {
        // echo json_encode(["status" => "error", "message" => "reCAPTCHA verification failed. Please refresh your page and try again."]);
        echo json_encode(["status" => "error", "message" => "There was an issue submitting your form, please give us a call at 1-800-245-RENT so we can further assist you."]);
        exit;
    }

    $zip_code = $_POST['zip_code'] ?? '';
    $first_name = $_POST['first_name'] ?? '';
    $last_name = $_POST['last_name'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $email = $_POST['email'] ?? '';
    $address = $_POST['address'] ?? '';
    $location = $_POST['location'] ?? null;

    if ($location !== null) {
        // Remove non-numeric characters
        $location = filter_var($location, FILTER_SANITIZE_NUMBER_INT);

        // Convert to integer and check length
        if (ctype_digit($location) && strlen($location) <= 3) {
            $location = (int) $location; // Cast to integer
        } else {
            $location = null; // Set to null if invalid
        }
    } else {
        $location = null;
    }

    if (empty($zip_code) || empty($first_name) || empty($last_name) || empty($phone) || empty($email) || empty($address)) {
        echo json_encode(["status" => "error", "message" => "All fields are required."]);
        exit;
    }

    $form = new Form();
    $result = $form->saveFormData($zip_code, $first_name, $last_name, $phone, $email, $address);
    
    if ($result === "Form submitted successfully!") {

        if($location) {

            try {
                // Use RM to insert as an owner prospect
                $rmAPI = new API($location);
                $ownerProspectData = [];

                error_log($address . ' ' . $phone);


                // Create owner prospect array
                $ownerProspectArray = array(
                    'Name' => $first_name . ' ' . $last_name,
                    'DisplayName' => $first_name . ' ' . $last_name,
                    'Email' => $email,
                    'Addresses' => [
                        array(
                            'AddressTypeID' => 7,
                            'Address' => $address,
                            'IsPrimary' => true,
                        ),
                    ],
                    'Contact' => [
                        'IsPrimary' => true,
                        'PhoneNumbers' => [
                            array(
                                'PhoneNumberTypeID' => 10,
                                'PhoneNumber' => $phone,
                                'IsPrimary' => true,
                                'IsTextReady' => true,
                            ),
                        ],
                    ],
                );

                // Insert into RM
                array_push($ownerProspectData, $ownerProspectArray);
                $response = $rmAPI->insertOwnerProspect($ownerProspectData);

                $logFile = 'api_response.log';

                if ($response !== false) {
                    // Open log file for appending
                    $handle = fopen($logFile, 'a'); 

                    if ($handle) {
                        // Write timestamp and response
                        fwrite($handle, "[" . date("Y-m-d H:i:s") . "] API Response:\n" . $response[0] . "\n\n");
                        fclose($handle); // Close file
                    } else {
                        echo "Error opening log file.";
                    }
                } else {
                    echo "Error fetching API response.";
                }

            } catch (Exception $e) {
            echo json_encode(["status" => "error", "message" => "Error inserting into owner prospects: " . $e->getMessage()]);
            }

        }

        try {
            
            $sendGridApiKey = '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';
            $sendGrid = new \SendGrid($sendGridApiKey);

            // Email to the user
            $userEmailMessage = new Mail();
            $userEmailMessage->setFrom("acprop@acfran.com", "The All County Team");
            $userEmailMessage->setSubject("Thank you for your submission");
            $userEmailMessage->addTo($email);
            $userEmailMessage->setTemplateId(
                new \SendGrid\Mail\TemplateId('d-987f7bfd58de4490921b246cb1f4dcf7.df07868e-03c4-4da6-80d4-d5c6aff9a4be')
            );
            $userEmailMessage->addDynamicTemplateDatas([
                "name" => "$first_name $last_name",
                "message" => "Thank you for reaching out! We will get back to you soon."
            ]);
            
            // Email to tech support
            $adminEmailMessage = new Mail();
            $adminEmailMessage->setFrom("acprop@acfran.com", "The All County Team");
            $adminEmailMessage->setSubject("New regional lead");
            $adminEmailMessage->addTo("techsupport@allcountyfranchise.com");
            $adminEmailMessage->setTemplateId(
                new \SendGrid\Mail\TemplateId('d-987f7bfd58de4490921b246cb1f4dcf7.e46b4832-3ca5-4124-a5d9-a92291b3c2fe')
            );
            $adminEmailMessage->addDynamicTemplateDatas([
                "name" => "Admin",
                "message" => "You've received a new regional lead, please view it in your FSS Dashboard."
            ]);

            // Send emails
            // $sendGrid->send($userEmailMessage);
            // $sendGrid->send($adminEmailMessage);
        
            echo json_encode(["status" => "success", "message" => "Form submitted and emails sent successfully!"]);
        } catch (Exception $e) {
            echo json_encode(["status" => "error", "message" => "Error sending emails: " . $e->getMessage()]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => $result]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request."]);
}
