<?php

// Pre-requisites
header('Content-Type: application/json');
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
$pageTitle = 'Locations';
$pageName = 'Locations';
$pageType = 0;

// Auto load classes
include($nestedLocation . 'resources/includes/class-autoload.inc.php');

// Initial API Instance for aafran (2) - This populates the location dropdown
$locationsAPI = new API(2);
$locationData = $locationsAPI->getFranchisees();

// Filter if there is a state parameter
if(isset($_GET['state'])) {
  $state = preg_replace("/[^a-zA-Z0-9]+/", "", $_GET['state']);
  $filteredLocations = [];
  foreach($locationData as $location) {
    if($location['State'] == $state) {
      array_push($filteredLocations, $location);
    }
  }
  unset($locationData);
  $locationData = $filteredLocations;
}

// Create a locations JSON file
$locationsJSON = array();
foreach($locationData as $franchise) {
  if($franchise['Name'] != 'Demo') {
    // generate web url variable
    if(!empty($franchise['URL'])) { if(isset($state)) { $sploshi = explode('/', $franchise['URL']); $webUrl = $sploshi[1]; } else { $webUrl = $franchise['URL']; } } else { $webUrl = 'https://' . $franchise['web site url']; }
    $latLng = explode(', ', $franchise['Geocoded address']);
    $data = array(
      'id' => $franchise['LocationID'],
      'name' => str_replace(' Property Management', '', $franchise['Franchise Name']),
      'lat' => $latLng[0],
      'lng' => $latLng[1],
      'category' => 'Franchise',
      'address' => $franchise['Street'],
      'address2' => '',
      'city' => $franchise['City'],
      'state' => $franchise['State'],
      'postal' => $franchise['PostalCode'],
      'phone' => $franchise['Phone Number'],
      'web' => $webUrl,
      'hours2' => '',
      'hours3' => '',
      'featured' => '',
      'features' => '',
    );
    array_push($locationsJSON, $data);
    unset($webURL);
  }
}

// Suncoast location, manual push
$suncoast = array(
      'id' => 2,
      'name' => 'All County Suncoast',
      'lat' => 27.7805517,
      'lng' => -82.7170557,
      'category' => 'Franchise',
      'address' => '5922 9th ave n',
      'address2' => '',
      'city' => 'St. Petersburg',
      'state' => 'FL',
      'postal' => '33710',
      'phone' => '727-541-2578',
      // 'web' => $franchise['web site url'],
      'web' => 'https://allcountysuncoast.com/',
      'hours1' => '9AM - 5PM',
      'hours2' => '',
      'hours3' => '',
      'featured' => '',
      'features' => '',
      'date' => '2020-12-12'
);

if(!isset($state) || $state == 'FL') {
  array_push($locationsJSON, $suncoast);
}

echo json_encode($locationsJSON);
?>