<?php
// Inject CORE
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/core/acpm/privacy/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->
      <div class="container mt-5">
        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pt-5">

            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Privacy Policy</li>
              </ol>
            </nav>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Privacy Policy</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted"><?php echo $pageMetaDescription; ?></p>
              </div>
            </div>
            
            <div class="container pt-3">
            <p><span style="font-size:12pt;">To continue to provide innovative solutions and services that respond to your needs, All County&reg; Property Management collects certain information (as described under The Types of Information We Collect). We respect the privacy of our customers. Law regulates our information handling practices and this Privacy Policy describes those practices.</span></p>
            <p><strong><span style="font-size:18pt;">All COUNTY&reg; PROPERTY MANAGEMENT&apos;S PRIVACY POLICY</span></strong></p>
            <p><span style="font-size:12pt;">This privacy policy summarizes the policies and practices regarding the collection, disclosure and confidentiality of information that we maintain. We are committed to protecting your privacy. We want you to understand what information we collect and how we use that information.&nbsp;</span></p>
            <p><strong><span style="font-size:18pt;">THE TYPES OF INFORMATION WE COLLECT</span></strong></p>
            <p><span style="font-size:12pt;">We collect nonpublic information from the following sources:&nbsp;</span></p>
            <ul>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information that we receive from you on applications or other forms, such as name, email, and&nbsp;</span><strong><span style="font-size:12pt;">phone numbers</span></strong><span style="font-size:12pt;">.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information obtained during conversations with you, or observed during visits to your premises.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information gathered during the course of managing your property association or business.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">To collect customer information from the above-stated sources, All County Property Management may use the following means of communication to gather information: written, in-person, telephone, facsimile, electronically and online.</span></p>
                </li>
            </ul>
            <p><strong><span style="font-size:18pt;">OPT IN/OUT</span></strong></p>
            <p><span style="font-size:12pt;">You can cancel the SMS service at any time. Just text &ldquo;STOP&rdquo; to the short code. After you send the SMS message &ldquo;STOP&rdquo; to us, we will send you an SMS message to confirm that you have been unsubscribed. After this, you will no longer receive SMS messages from us. If you want to join again, just sign up as you did the first time and we will start sending SMS messages to you again.</span></p>
            <p><strong><span style="font-size:18pt;">HOW WE DISCLOSE INFORMATION WITH NON-AFFILIATED THIRD PARTIES</span></strong></p>
            <p><span style="font-size:12pt;">The information that we collect, as described above, is used for managing our services to you. We do not share information about our customers, or former customers, such as their names, emails, or phone numbers with non-affiliated third parties other than as permitted or required by law. For example All County Property Management may share all of the information listed above with non-affiliated third parties for, including but not limited to, the following reasons.&nbsp;</span></p>
            <ul>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information that is necessary to protect the confidentiality or security of our clients&apos; records.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information that is necessary to investigate and resolve client disputes or inquiries.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information that is required by individuals or entities who are assessing our legal compliance.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information that is required for All County Property Management to comply with the law.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">To an actuarial or research organization for the purpose of conducting actuarial or research studies.</span></p>
                </li>
                <li style="list-style-type:disc;font-size:12pt;">
                    <p><span style="font-size:12pt;">Information that is necessary to protect against or prevent fraud, unauthorized transactions, claims or other liability.</span></p>
                </li>
            </ul>
            <p><span style="font-size:12pt;">Examples of non-affiliated third parties with whom we are permitted or required by law to share information with are insurance carriers, insurance brokers, loss payees, additional insured&rsquo;s and joint marketing partners.</span></p>
            <p><strong><span style="font-size:18pt;">HOW WE SHARE CLIENT INFORMATION WITH AFFILIATED PARTIES</span></strong></p>
            <p><span style="font-size:12pt;">We do not share client information including names, emails, and phone numbers with any affiliate.&nbsp;</span></p>
            <p><strong><span style="font-size:18pt;">HOW WE PROTECT INFORMATION</span></strong></p>
            <p><span style="font-size:12pt;">We restrict access to non-public information to outside service providers who need to know that information to provide products or services to you. We use a secure Internet and e-mail provider to protect the confidentiality of electronic communications. Appropriate action would be taken against any employee who impermissibly shares client information. We regularly review our security measures and employee education programs to help protect this information and when we share information with nonaffiliated third parties, we require that they have standards to keep this information private.</span></p>
            <p><strong><span style="font-size:18pt;">DISPUTE RESOLUTION</span></strong></p>
            <p><span style="font-size:12pt;">Any controversy or claim arising out of, or relating to, our privacy policy, or the breach thereof, shall be settled by arbitration in accordance with the rules of the American Arbitration Association, and judgment upon the award rendered by the arbitrator(s) may be entered in any court having jurisdiction thereof.</span></p>
            <p><strong><span style="font-size:18pt;">RESERVATION OF THE RIGHTS TO DISCLOSE INFORMATION IN UNFORESEEN CIRCUMSTANCES</span></strong></p>
            <p><span style="font-size:12pt;">In connection with potential unforeseen circumstances, such as compliance with regulatory agencies or the sale, share or transfer of its interests, All County Property Management reserves the right to sell, share or transfer your information to a third-party entity that: 1) concentrates its business in a similar practice or service; 2) agrees to be the All County&reg; &nbsp;Property Management successor in interest with regard to the maintenance and protection of the information collected; and 3) agrees to the obligations of this privacy statement.</span></p>
            <p><strong><span style="font-size:18pt;">WHO TO CONTACT REGARDING PRIVACY MATTERS</span></strong></p>
            <p><span style="font-size:12pt;">You can contact All County Property Management by:</span></p>
            <p><span style="font-size:11pt;">Phone: (727) 800-3700</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Fax: (855) 243-RENT</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Email: contact@allcountyprop.com</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Address: 1700 66th St N Suite #402, St. Petersburg, FL 33710</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Entity: All County Property Management Franchise Corp</span></p>
                        </div>

            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- CTA-->
            <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/lightgallery.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/fullscreen/lg-fullscreen.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/zoom/lg-zoom.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/video/lg-video.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/thumbnail/lg-thumbnail.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

    <div class="lg-container" id="lg-container-2" tabindex="-1" aria-modal="true" role="dialog">
      <div id="lg-backdrop-2" class="lg-backdrop" style="transition-duration: 300ms;"></div>
      <div id="lg-outer-2" class="lg-outer lg-use-css3 lg-css3 lg-single-item lg-slide lg-use-transition-for-zoom lg-hide-items lg-grab" data-lg-slide-type="video">
        <div id="lg-content-2" class="lg-content" style="top: 47px; bottom: 56px;">
          <div id="lg-inner-2" class="lg-inner" style="transition-timing-function: ease; transition-duration: 400ms;"></div>
          <button type="button" id="lg-prev-2" aria-label="Previous slide" class="lg-prev lg-icon">  </button>
          <button type="button" id="lg-next-2" aria-label="Next slide" class="lg-next lg-icon">  </button>
        </div>
        <div id="lg-toolbar-2" class="lg-toolbar lg-group"> 
          <button type="button" aria-label="Close gallery" id="lg-close-2" class="lg-close lg-icon"></button>
          <div class="lg-counter" role="status" aria-live="polite">
          <span id="lg-counter-current-2" class="lg-counter-current">1</span> /
          <span id="lg-counter-all-2" class="lg-counter-all">1 </span>
        </div>
        <button id="lg-actual-size-2" type="button" aria-label="View actual size" class="lg-zoom-in lg-icon"></button>
        <button type="button" aria-label="Toggle Fullscreen" class="lg-fullscreen lg-icon"></button>
      </div>
      <div id="lg-components-2" class="lg-components">
        <div class="lg-sub-html" role="status" aria-live="polite">
          <h6 class="fs-sm text-light">Gallery video caption</h6>
        </div>
      </div>
    </div>


  </body>
</html>