<main class="page-wrapper">

  <!-- INC/LAYOUT - Navigation Bar -->
  <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

  <!-- Page content-->

  <section class="pt-5 jarallax bg-light zindex-1 py-xxl-5" id="header">
    <span class="img-overlay bg-transparent opacity-100" style="background: linear-gradient(180deg, rgba(255,255,255,1) 0%, rgba(255,255,255,1) 18%, rgba(255,255,255,0.9023984593837535) 35%, rgba(255,255,255,0.6051155462184874) 100%); box-shadow: inset 0px -11px 8px -10px #CCC;"></span>
    <div class="jarallax-img" style="background-image: url(<?php echo $nestedLocation; ?>resources/img/regions/orlando-region-bg.jpg); background-position: bottom center;"></div>
    <div class="content-overlay container py-5">
      <div class="row pt-4">
        <div class="col-xl-5 col-lg-6 col-md-7 mb-3 text-md-start text-center">
          <h1 class="display-4 mt-lg-3 mb-md-4 mb-3 pt-md-4 pb-lg-2" style="word-spacing: 100vw;">
            <a class="text-primary fw-italic text-decoration-none"><?php echo $region; ?></a>
          <br>Property Management</h1>
          <p class="position-relative mb-md-4 mb-3 lead me-lg-n5 fw-bold"><i>Let's rent your home today!</i></p>
          <!-- <p class="position-relative lead me-lg-n5">Discover how our expert team can maximize your property's potential in <?php echo $region; ?> and provide you with peace of mind.</p> -->
          <br>
          
            <button class="btn btn-lg btn-primary" data-bs-toggle="modal" data-bs-target="#formModal"><span class="d-none d-md-block">Get Started</span> <i class="fi-arrow-right mt-0 mx-2"></i></button>
          
        </div>
      </div>
    </div>
  </section>

  <section class="w-100 bg-secondary">
    <div class="container pt-3 pb-2">
      <h3 class="h3 mb-1">Professional Property Management in <?php echo $region; ?></h5>
      <h6 class="text-primary"><i>Some tagline about the region here.</i></h6>
    </div>
  </section>

  <!-- About All County -->
  <section class="container pt-4 mb-5 pb-lg-5" id="statesWeService">
    <div class="col-lg-12 mt-3">
      <!-- <h4 class="h4 mb-0">We're a full-service property management company.</h4> -->
      <!-- <br> -->
      <div class="text-center mb-4">
        <div class="row gy-4 align-items-lg-center">
          <div class="col-lg-6 col-md-6 order-md-1 order-2 pe-4 text-md-start text-center">
            <p>Welcome to All County Property Management, where we provide expert property management services tailored to meet the needs of property owners and tenants in the Orlando, FL area. Our in-depth knowledge of Orlando's real estate market allows us to offer exceptional service, customized to the unique character of this vibrant city and its surrounding communities.</p>
            <br>
            <h4 class="h4 mb-0">Why <?php echo $region; ?>?</h4>
            <br>
            <p>Orlando, known for its world-famous theme parks, vibrant arts scene, and booming economy, is one of Florida's most desirable cities for both residents and investors. From the bustling downtown district to the charming neighborhoods of Winter Park and College Park, as well as the suburban areas of Lake Nona and Dr. Phillips, Orlando offers diverse living environments to suit every lifestyle. The city's strong job market, particularly in tourism, healthcare, and tech industries, along with its excellent schools and cultural amenities, make it an ideal location for renters and property investors alike. With its year-round warm weather, recreational attractions, and rapid growth, Orlando continues to be a top choice for those looking to live and invest in Central Florida.</p>
          </div>
          <div class="col-md-6 order-md-2 order-1 ps-4">
            <img class="rounded-3" src="<?php echo $nestedLocation; ?>resources/img/regions/orlando-region-bg.jpg" alt="Regional image">
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Offices -->
  <section class="container pt-4 mb-5 pb-lg-5" id="statesWeService">
    <div class="col-lg-12 mt-3">
      <!-- <h4 class="h4 mb-0">We're a full-service property management company.</h4> -->
      <!-- <br> -->
      <div class="text-center mb-4">
        <div class="row gy-4 align-items-lg-center">
          <div class="col-lg-6 col-md-6 order-md-1 order-2 pe-4 text-md-start text-center">
            <p>Welcome to All County Property Management, where we provide expert property management services tailored to meet the needs of property owners and tenants in the Orlando, FL area. Our in-depth knowledge of Orlando's real estate market allows us to offer exceptional service, customized to the unique character of this vibrant city and its surrounding communities.</p>
            <br>
            <h4 class="h4 mb-0">Why <?php echo $region; ?>?</h4>
            <br>
            <p>Orlando, known for its world-famous theme parks, vibrant arts scene, and booming economy, is one of Florida's most desirable cities for both residents and investors. From the bustling downtown district to the charming neighborhoods of Winter Park and College Park, as well as the suburban areas of Lake Nona and Dr. Phillips, Orlando offers diverse living environments to suit every lifestyle. The city's strong job market, particularly in tourism, healthcare, and tech industries, along with its excellent schools and cultural amenities, make it an ideal location for renters and property investors alike. With its year-round warm weather, recreational attractions, and rapid growth, Orlando continues to be a top choice for those looking to live and invest in Central Florida.</p>
          </div>
          <div class="col-md-6 order-md-2 order-1 ps-4">
            <img class="rounded-3" src="<?php echo $nestedLocation; ?>resources/img/regions/orlando-region-bg.jpg" alt="Regional image">
          </div>
        </div>
      </div>

      <br>
      <hr>

      <!-- Offices -->
      <div class="d-flex align-items-center justify-content-between mb-3 pt-5">
        <h2 class="h3 mb-3">We've Got Roots in <?php echo $region; ?></h2>
        <!-- <a class="btn btn-link fw-normal p-0" href="locations/">View all offices<i class="fi-arrow-long-right ms-2"></i></a> -->
      </div>
      <div class="tns-carousel-wrapper tns-nav-outside tns-nav-outside-flush mx-n2 rounded-3">
        <div class="tns-carousel-inner row gx-4 mx-0 py-3" data-carousel-options="{&quot;items&quot;: 4, &quot;controls&quot;: true, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:1},&quot;768&quot;:{&quot;items&quot;:4}}}">
          <?php foreach($filteredLocations as $location) { ?>
          <div class="col-sm-6 col-xl-4">
            <div class="card shadow-sm card-hover border-0 h-100">
              <div class="card-img-top card-img-hover state-office-image" style="height: 250px; background-image: url('<?php echo $location['ImageURL']; ?>');">
              </div>
              <div class="card-body position-relative pt-4 pb-2 text-center">
                <h6><?php echo str_replace(' Property Management', '', $location['franchise_name']); ?></h6>
              </div>
            </div>
          </div>
          <?php } ?>
        </div>
      </div>

      <br>
      <hr>

      <h4 class="h3 mb-0 mt-5">Professional services we offer:</h3>

      <div class="row pt-5">
          
        <div class="col-lg-12 d-flex align-items-stretch mb-5">
          <div class="card w-100 bg-gradient text-white text-center pt-3">
            <div class="card-header h5 border-0">
              <i class="fi-rent mb-4 display-6"></i>
              <br>
              Local Expertise
            </div>
            <div class="card-body">
              <p>
              With extensive local expertise in Orlando, we specialize in managing properties across the city's vibrant neighborhoods, including downtown, Winter Park, and Lake Nona. Our deep understanding of Orlando's real estate trends and community dynamics allows us to provide personalized, effective property management services that maximize returns for property owners.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Tenant Screening
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Comprehensive background checks, credit evaluations, and reference verifications to ensure you attract and retain reliable and responsible tenants.</p>
            </div>
          </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Property Marketing
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Strategic marketing plans, including professional photography and listings on major rental platforms, to highlight your property’s best features and attract quality tenants quickly.</p>
            </div>
          </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Maintenance and Repairs
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Efficient handling of maintenance and repair issues through a network of trusted local contractors, ensuring your property is well-maintained and any problems are addressed promptly.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Rent Collection
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Streamlined rent collection processes with multiple payment options, including online payments, to ensure consistent and timely rental income.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5 d-none">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Financial Reporting
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Transparent financial reporting with detailed statements of income, expenses, and property performance to keep you informed and facilitate informed decision-making.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5 d-none">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Legal Compliance
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Expertise in Atlanta’s local, state, and federal regulations to ensure your property adheres to all legal requirements and to help prevent potential legal issues.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>
        
        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Tenant Relations
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Responsive and professional tenant support to handle inquiries, resolve issues, and maintain high levels of tenant satisfaction.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>
        
        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Property Inspections
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Regular property inspections to monitor the condition of your property, identify maintenance needs, and ensure it remains in top condition.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5 d-none">
          <div class="card w-100">
            <div class="card-header h5 bg-gradient text-white">
              Eviction Services
            </div>
            <div class="card-body pb-0">
              <div class="text-center my-3">
                <i class="fi-user-check mb-4 display-6"></i>
              </div>
              <p>Assistance with the eviction process, including legal guidance and coordination with local authorities, to handle difficult situations with professionalism.</p>
            </div>
            <!-- <div class="card-footer border-0">
              <div class="btn btn-sm text-black btn-secondary">Learn more</div>
            </div> -->
          </div>
        </div>

      </div>
      <!-- <br>
      <p>Experience the benefits of working with a property management team that truly understands Atlanta. Contact us today to learn how we can help you manage your property with expertise and dedication.</p>
      <a class="btn btn-lg btn-primary" href="about/">Work with us!</a> -->
    </div>
  </section>

  <!-- Partner with us -->
  <hr>
  <section class="container mt-5 pb-5">
    <div class="row gy-4">
      <div class="col-md-5 col-12"><img class="d-block mx-auto" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/sell.svg" alt="Illustration"></div>
      <div class="col-lg-6 offset-lg-1 col-md-7 col-12">
        <h2 class="h3 mb-lg-5 mb-sm-4">Why partner with a <?php echo $region; ?> market expert?</h2>
        <div class="steps steps-vertical">
          <div class="step active">
            <div class="step-progress"><span class="step-number"></span></div>
            <div class="step-label ms-4">
              <h3 class="h5 mb-2 pb-1">Expert Knowledge of the Orlando Market</h3>
              <p class="mb-0">Partnering with us means tapping into our extensive knowledge of the Orlando real estate market. We are familiar with the unique characteristics of Orlando’s diverse neighborhoods, from the bustling downtown area to the charming streets of Winter Park, and the rapidly developing regions like Lake Nona and Baldwin Park. Our deep understanding of local trends, rental rates, and zoning laws enables us to help you make informed decisions about your investment and optimize the profitability of your property.</p>
            </div>
          </div>
          <div class="step active">
            <div class="step-progress"><span class="step-number"></span></div>
            <div class="step-label ms-4">
              <h3 class="h5 mb-2 pb-1">Comprehensive & Reliable Property Management Services</h3>
              <p class="mb-0">Our full suite of property management services is designed to simplify the entire process of owning and renting property in the Orlando area. From tenant screening and placement to maintenance and repairs, we handle every aspect of property management with professionalism and attention to detail. We use targeted marketing strategies to quickly find quality tenants and ensure that your property is maintained to the highest standards, protecting your investment while saving you time and effort.</p>
            </div>
          </div>
          <div class="step active">
            <div class="step-progress"><span class="step-number"></span></div>
            <div class="step-label ms-4">
              <h3 class="h5 mb-2 pb-1">Commitment to Tenant Satisfaction & Retention</h3>
              <p class="mb-0">At All County Property Management, we understand that happy tenants are the key to long-term rental success. We prioritize clear communication, prompt responses to concerns, and proactive property maintenance to ensure that tenants are satisfied and remain in place longer. Our focus on building positive landlord-tenant relationships helps reduce turnover and vacancies, ensuring consistent rental income for property owners. Whether you own a single-family home in College Park or a condo in Dr. Phillips, our goal is to provide the best possible management experience for both you and your tenants.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Reviews -->
  <hr>
  <section class="container mt-5 pb-5">
    <h2 class="mb-1">Reviews:</h2>
    <h6 class="mb-4 text-primary">Don't just take our word, see what actual owners have to say about All County.</h6>

    <div class="tns-carousel-wrapper tns-controls-outside-xxl tns-nav-outside tns-nav-outside-flush mx-n2">
      <div class="tns-carousel-inner row gx-4 mx-0 pt-3 pb-4" data-carousel-options="{&quot;items&quot;: 3, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:2},&quot;768&quot;:{&quot;items&quot;:3},&quot;992&quot;:{&quot;items&quot;:3}}}">

        <!-- Item-->
        <div class="col">
          <div class="card border-0 shadow-sm">
            <blockquote class="blockquote card-body">
              <p class="font-italic">"I couldn't be happier with the property management services provided! The team is incredibly responsive and genuinely cares about my property as if it were their own. They handle everything from tenant screening to maintenance issues with professionalism and efficiency. It's such a relief knowing my investment is in such capable hands!"</p>
              <footer class="d-flex justify-content-between">
                <div class="pe-3">
                  <h6 class="mb-0">Christine Carter</h6>
                </div>
              </footer>
            </blockquote>
          </div>
        </div>

          <!-- Item-->
          <div class="col">
          <div class="card border-0 shadow-sm">
            <blockquote class="blockquote card-body">
              <p class="font-italic">"As a property owner, finding reliable management can be challenging, but this team has exceeded my expectations. Their communication is top-notch, keeping me updated on everything happening with my property. I appreciate their proactive approach to maintenance and tenant relations, which has led to happy tenants and fewer vacancies. Highly recommend!"</p>
              <footer class="d-flex justify-content-between">
                <div class="pe-3">
                  <h6 class="mb-0">Micah Davis</h6>
                </div>
              </footer>
            </blockquote>
          </div>
        </div>

        <!-- Item-->
        <div class="col">
          <div class="card border-0 shadow-sm">
            <blockquote class="blockquote card-body">
              <p class="font-italic">"I’ve worked with several property management companies over the years, but none compare to this one. They bring expertise and dedication to every aspect of managing my rental. Their thorough screening process has brought in excellent tenants, and I love the regular updates I receive. I feel confident and supported as an owner, which is invaluable!"</p>
              <footer class="d-flex justify-content-between">
                <div class="pe-3">
                  <h6 class="mb-0">Christopher Mathews</h6>
                </div>
              </footer>
            </blockquote>
          </div>
        </div>

      </div>
  </section>

</main>