<?php
// Prerequisites
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// Allowed regions array
$regionsArr = array(
  'jacksonville' => array(
    'state' => 'florida',
    'state_abbr' => 'fl'
  ),
  'miami' => array(
    'state' => 'florida',
    'state_abbr' => 'fl'
  ),
  'orlando' => array(
    'state' => 'florida',
    'state_abbr' => 'fl'
  ),
  'tampa' => array(
    'state' => 'florida',
    'state_abbr' => 'fl'
  ),
  'atlanta' => array(
    'state' => 'georgia',
    'state_abbr' => 'ga'
  ),
  'los angeles' => array(
    'state' => 'california',
    'state_abbr' => 'ca'
  ),
  'chicago' => array(
    'state' => 'illinois',
    'state_abbr' => 'il'
  ),
  'cleveland' => array(
    'state' => 'ohio',
    'state_abbr' => 'oh'
  ),
  'dallas' => array(
    'state' => 'texas',
    'state_abbr' => 'tx'
  ),
  'houston' => array(
    'state' => 'texas',
    'state_abbr' => 'tx'
  ),
  'san antonio' => array(
    'state' => 'texas',
    'state_abbr' => 'tx'
  ),
);

// Get secondary city from url
$sanitize = new Sanitize();
$region = ucwords(str_replace('-', ' ', str_replace('-property-management', '', $sanitize->slugSanitizer(strtolower($_GET['id'])))));

// if(!in_array($region, $regionsArr)) {
//   header("Location: https://www.allcountyprop.com/");
//   die();
// }

// Additional params
$state = 'Florida';
$stateAbr = 'FL';

// API Instance
$RMAPI = new API(2);

// Get locations
$locations = $RMAPI->getFranchisees();

// Set page parameters/meta
$pageType = 0;
$pageName = 'ACPM.Region';
$pageTitle = $region . ' Property Management | Rent Your Home';
$pageMetaDescription = 'Rent your ' . $region . ' property the easy way with All County. We take care of all accomodations of your invesement property.';
$pageMetaKeyword = array(
  'property management office', 'find a property management company', $region . ' property management', 'best ' . $region . ' property manager', 'rent my home', 'rent my home in ' . $region
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);


// Filter offices to current state only
$filteredLocations = [];
foreach($locations as $location) {
  if($location['region_group'] == $region) {
    array_push($filteredLocations, $location);
  }
}

// Get location images
$officeData = new FetchOfficeData();
foreach($filteredLocations as $k => $individualOffice) {
  $latestOfficeImage = $officeData->getLatestImageData($individualOffice['name'], 1);
  $officeImage =  $latestOfficeImage['url'];
  $filteredLocations[$k]['ImageURL'] = $officeImage;
}

?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- INC/LAYOUT - Head -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCQ5N81u7-cdQ665QokzjzJ3ZQe1HdmabE&libraries=places"></script>
    <script src="https://www.google.com/recaptcha/api.js?render=6Le5EswqAAAAAGZbnzM8oiTA4s5rh3BvFBdANTig"></script>
    <style>
        .pac-container {
            z-index: 9999 !important; /* Ensures autocomplete dropdown appears above Bootstrap modal */
        }
        .vertical-divider {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            position: relative;
            width: 20px;
            height: 100%;
        }

        .vertical-divider::before,
        .vertical-divider::after {
            content: "";
            position: absolute;
            width: 2px;
            height: 40%;
            background-color: #ccc;
        }

        .vertical-divider::before {
            top: 0;
        }

        .vertical-divider::after {
            bottom: 0;
        }

        .divider-text {
            display: flex;
            flex-direction: column;
            align-items: center;
            font-weight: bold;
            color: #6c757d;
            background-color: white;
            padding: 5px;
            line-height: 1;
        }
    </style>
  </head>
  <body>

    <!-- INC/LAYOUT - Page Loader & GTM-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <!-- load body view -->
    <?php include_once('layouts/' . strtolower($region) . '.layout.php'); ?>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Modal -->
    <div class="modal modal-lg fade" id="formModal" tabindex="-1" aria-labelledby="formModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-center justify-content-center">
                    <h5 class="modal-title fw-light" id="formModalLabel">Get a Free Property Management Consultation</h5>
                </div>
                <div class="modal-body">
                    <div id="alertBox" class="alert d-none" role="alert"></div>
                    <div id="thankYouMessage" class="d-none text-center text-success fw-bold">
                        Thank you for your inquiry! Our property management experts will contact you shortly.
                    </div>
                    
                    <!-- Step 1: ZIP Code Input -->
                    <div id="step1" class="form-container">

                        <div class="row">
                          <div class="col-md-6 text-center">
                            <p class="fw-bold">To begin, please enter the ZIP code where your property is located:</p>
                            <div class="mb-3">
                                <input type="text" class="form-control" id="zip_code" name="zip_code" required pattern="^[0-9]{5}$" placeholder="Enter ZIP code">
                            </div>
                            <button type="button" class="btn btn-primary w-100" id="nextStep">Next</button>
                          </div>
                          <!-- Divider Column -->
                          <div class="col-md-1 d-flex justify-content-center">
                            <div class="vertical-divider">
                                <div class="divider-text">
                                    <span>O</span>
                                    <span>R</span>
                                </div>
                            </div>
                          </div>
                          <div class="col-md-5 text-center justify-content-center">
      
                            <p class="text-muted text-center mt-3">Prefer to speak with someone?</p>
                            <a class="btn btn-primary btn-sm ms-3" href="<?php echo $officeNestedLocation; ?>quote/"><span class=""><strong>1-800-245-RENT</strong></span></a>
                            <p class="text-muted text-center mt-3">Our professional property managers are on standby to answer any of your questions.</p>

                          </div>
                        </div>

                    </div>

                    <!-- Step 2: Main Form -->
                    <form id="userForm" class="d-none form-container">
                        <input type="hidden" id="hidden_zip_code" name="zip_code">
                        <input type="hidden" id="hidden_location" name="location" value="<?php echo $location; ?>">
                        <p class="fw-bold text-center">Tell us about yourself</p>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="first_name" name="first_name" required placeholder="First Name">
                            </div>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="last_name" name="last_name" required placeholder="Last Name">
                            </div>
                        </div>
                        <div class="mb-3">
                            <input type="text" class="form-control" id="phone" name="phone" required pattern="^\+?[0-9]{10,15}$" placeholder="Phone Number">
                        </div>
                        <div class="mb-3">
                            <input type="email" class="form-control" id="email" name="email" required placeholder="Email Address">
                        </div>
                        <div class="mb-3">
                            <input type="text" class="form-control" id="address" name="address" required minlength="5" placeholder="Property Address">
                            <small class="form-text text-muted">Start typing and select from the autocomplete suggestions.</small>
                        </div>
                        <input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response">
                        <button type="submit" class="btn btn-primary w-100">Submit Your Inquiry</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function initAutocomplete() {
        let input = document.getElementById('address');
        let autocomplete = new google.maps.places.Autocomplete(input);

        // Listen for place selection
        autocomplete.addListener('place_changed', function () {
            let place = autocomplete.getPlace();
            let formattedAddress = place.formatted_address || "";
            let zipCode = "";

            if (place.address_components) {
                for (let i = 0; i < place.address_components.length; i++) {
                    let component = place.address_components[i];
                    let types = component.types;

                    if (types.includes("postal_code")) {
                        zipCode = component.long_name; // Extract ZIP code
                    }
                }
            }

            // Append ZIP code if found and not already included
            if (zipCode && !formattedAddress.includes(zipCode)) {
                formattedAddress += `, ${zipCode}`;
            }

            // Update Address input field
            input.value = formattedAddress;

            // Also update the hidden ZIP code field if needed
            document.getElementById('zip_code').value = zipCode;

            console.log("Formatted Address:", formattedAddress); // Debugging
        });
    }

        google.maps.event.addDomListener(window, 'load', initAutocomplete);

        grecaptcha.ready(function() {
            grecaptcha.execute('6Le5EswqAAAAAGZbnzM8oiTA4s5rh3BvFBdANTig', {action: 'submit'}).then(function(token) {
                document.getElementById('g-recaptcha-response').value = token;
            });
        });

        function showAlert(message, type) {
            let alertBox = $('#alertBox');
            alertBox.removeClass('d-none alert-success alert-danger').addClass(`alert-${type}`).text(message);
        }

        $(document).ready(function () {
            $('#nextStep').click(function () {
                let zipCode = $('#zip_code').val().trim();
                if (/^[0-9]{5}$/.test(zipCode)) {
                    $('#hidden_zip_code').val(zipCode);
                    $('#step1').addClass('d-none');
                    $('#userForm').removeClass('d-none');
                    $('#alertBox').addClass('d-none');
                } else {
                    showAlert("Please enter a valid 5-digit ZIP code.", "danger");
                }
            });

            $('#userForm').submit(function (e) {
                e.preventDefault();
                let formData = $(this).serialize();

                // Disable submit button while processing
                let submitButton = $('button[type="submit"]');
                submitButton.prop('disabled', true);
                
                $.ajax({
                    type: 'POST',
                    url: '<?php echo $nestedLocation; ?>resources/helpers/form-handler.php',
                    data: formData,
                    dataType: 'json',
                    success: function (response) {
                        if (response.status === "success") {
                            $('#alertBox').addClass('d-none');
                            $('#userForm').addClass('d-none');
                            $('#thankYouMessage').removeClass('d-none');
                        } else {
                            showAlert(response.message, "danger");

                        }
                    },
                    error: function () {
                        showAlert("Error submitting form.", "danger");
                    }
                });
            });
        });
    </script>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

    <!-- Script for fullscreen map -->
    <!-- <script type="text/javascript" src="//maps.googleapis.com/maps/api/js?key=AIzaSyCQ5N81u7-cdQ665QokzjzJ3ZQe1HdmabE&libraries=places"></script> -->
    <script type="text/javascript" id="storelocatorscript" data-uid="D7kc8VYWof3ULCm1VmkUcQbuYFMOpj45" data-zoom="6" data-filters="Atlanta" data-address="Atlanta" data-settings="store_list_layout=Disabled" src="//cdn.storelocatorwidgets.com/widget/widget.js"></script>

    <script>
      $(document).ready(function () {
        $('#submit_zip').on('submit', function(e) {
            console.log('Data submitted');
            e.preventDefault();
            var zip = $('#address').val;
            console.log(zip);
            $('#locator').modal('show'); 
        });
      });
    </script>

  </body>
</html>