<?php
$nestedLocation = '../../';

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

header('Content-Type: application/json');

// Debug: Log all incoming headers to check what is being received
error_log("Incoming Headers: " . json_encode(getallheaders()));


// 🔹 Restrict to AJAX Requests Only
if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') {
    http_response_code(403);
    die(json_encode(["error" => "Access forbidden."]));
}

// 🔹 Restrict to Your Own Domain
$allowedDomain = "new.aquaactionfl.com"; // Change to your actual domain
if (!isset($_SERVER['HTTP_REFERER']) || !preg_match("/^https?:\/\/(www\.)?$allowedDomain/", $_SERVER['HTTP_REFERER'])) {
    http_response_code(403);
    die(json_encode(["error" => "Unauthorized request."]));
}

try {

    $location = isset($_GET['location']) ? 1 . sanitize_integer($_GET['location']) : 0;

    // Handle fetching the unique filter options
    if (isset($_GET['action']) && $_GET['action'] === 'getFilters') {
        
        $listingsObj = new Listings();

        // Fetch unique filter options from the database
        $filters = $listingsObj->getUniqueFilters($location);

        echo json_encode($filters);
        exit;
    }

    // Handle fetching listings when action is not 'getFilters'
    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        $listingsObj = new Listings();

        error_log("Raw GET data: " . json_encode($_GET));


        // Extract filters from GET request with sanitization
        // $filters = [
        //     'propertyType' => isset($_GET['propertyType']) ? array_map('sanitize_value', explode(',', urldecode($_GET['propertyType']))) : [],
        //     'city' => isset($_GET['city']) ? array_map('sanitize_value', explode(',', urldecode($_GET['city']))) : [],
        //     'beds' => isset($_GET['beds']) ? array_map('sanitize_bed_bath', explode(',', urldecode($_GET['beds']))) : [],
        //     'baths' => isset($_GET['baths']) ? array_map('sanitize_bed_bath', explode(',', urldecode($_GET['baths']))) : [],
        //     // 'minRent' => isset($_GET['minRent']) ? (int) $_GET['minRent'] : null,
        //     // 'maxRent' => isset($_GET['maxRent']) ? (int) $_GET['maxRent'] : null
        //     'minRent' => isset($_GET['minRent']) && is_numeric($_GET['minRent']) ? (int) $_GET['minRent'] : 0,
        //     'maxRent' => isset($_GET['maxRent']) && is_numeric($_GET['maxRent']) ? (int) $_GET['maxRent'] : 10000
        // ];
        $filters = [
            'propertyType' => isset($_GET['propertyType']) ? array_map('sanitize_value', explode(',', urldecode($_GET['propertyType']))) : [],
            'city' => isset($_GET['city']) ? array_map('sanitize_value', explode(',', urldecode($_GET['city']))) : [],
            'beds' => isset($_GET['beds']) ? array_map('sanitize_bed_bath', explode(',', urldecode($_GET['beds']))) : [],
            'baths' => isset($_GET['baths']) ? array_map('sanitize_bed_bath', explode(',', urldecode($_GET['baths']))) : [],
            
            'minRent' => isset($_GET['minRent']) ? sanitize_integer($_GET['minRent']) : 0,
            'maxRent' => isset($_GET['maxRent']) ? sanitize_integer($_GET['maxRent']) : 10000,
            'dogs' => isset($_GET['dogs']) ? (int)$_GET['dogs'] : null,
            'cats' => isset($_GET['cats']) ? (int)$_GET['cats'] : null
        ];
        
        

        // $filters = [
        //     'propertyType' => isset($_GET['propertyType']) ? array_map('sanitize_value', explode(',', urldecode($_GET['propertyType']))) : [],
        //     'city' => isset($_GET['city']) ? array_map('sanitize_value', explode(',', urldecode($_GET['city']))) : [],
        //     'beds' => isset($_GET['beds']) ? array_map('sanitize_integer', explode(',', urldecode($_GET['beds']))) : [],
        //     'baths' => isset($_GET['baths']) ? array_map('sanitize_integer', explode(',', urldecode($_GET['baths']))) : [],
        //     'minRent' => isset($_GET['minRent']) ? sanitize_integer($_GET['minRent']) : 0,
        //     'maxRent' => isset($_GET['maxRent']) ? sanitize_integer($_GET['maxRent']) : 10000
        // ];

        error_log("Received Filters: " . json_encode($filters));
        

        
        
        // Sanitize and validate sort option
        $sort = $_GET['sort'] ?? 'price_desc';
        $validSortOptions = ['price_asc', 'price_desc', 'date_soonest', 'date_latest'];
        if (!in_array($sort, $validSortOptions)) {
            $sort = 'price_desc'; // Default to price_asc if invalid
        }

        // Validate and sanitize page
        $page = isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0 ? (int)$_GET['page'] : 1;

        // Fetch listings
        $listings = $listingsObj->getListings($filters, $sort, $page, $location);
        $total_count = $listingsObj->getTotalCount($filters, $location);
        $limit = $listingsObj->getLimit();

        // Return JSON response
        echo json_encode([
            'listings' => $listings,
            'total_count' => $total_count,
            'limit' => $limit,
            'total_pages' => ceil($total_count / $limit)
        ]);
    } else {
        echo json_encode(['error' => 'Invalid request method.']);
    }


} catch (Exception $e) {
    error_log("Error in listings-handler.php: " . $e->getMessage());
    echo json_encode(['error' => 'An error occurred while fetching listings.']);
}
function sanitize_value($value) {
    // Apply htmlspecialchars to avoid XSS attacks
    // return htmlspecialchars(trim($value), ENT_QUOTES, 'UTF-8');
    return htmlspecialchars(strip_tags(trim($value)), ENT_QUOTES, 'UTF-8');
}

function sanitize_bed_bath($value) {
    $value = trim($value);
    if ($value === '4+') {
        return '4+'; // Preserve "4+" as a special case
    }
    return intval($value); // Convert everything else to an integer
}

// function sanitize_value($value) {
//     return htmlspecialchars(strip_tags(trim($value)), ENT_QUOTES, 'UTF-8');
// }

function sanitize_integer($value) {
    return filter_var($value, FILTER_VALIDATE_INT) !== false ? (int)$value : 0;
}

?>

