<?php

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);

// Sanitization
$sanitize = new Sanitize;

// Get locations
$locations = $RMAPI->getFranchisees();

// Set page parameters/meta
$pageType = 0;
$pageName = 'ACPM.Blog';
$pageTitle = 'Blog | All County Property Management';
$pageMetaDescription = 'Get property management tips and tricks for success from the experts on the All County Property Management blog.';
$pageMetaKeyword = array(
  'property management office', 'blog', 'blog posts', 'articles', 'property management blog', 'how to rent your home'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Include WP
define('WP_USE_THEMES', false);
require($nestedLocation . '../' . 'cms/wp-load.php');

// Sanitize the page number
$page = $sanitize->numbersOnly($_GET['page']);

// Get the page number
if(!$page) {
  $pageNumber = 1;
} else {
  $pageNumber = $page;
}

// WP Query
$temp = $query;
$query = null;
$query = new WP_Query(array(
  'post_status' => 'publish',
  'cat' => 2,
  'orderby' => 'date',
  'order' => 'DESC',
  'posts_per_page' => '10',
  'paged' => $pageNumber,
));

$totalNumberOfPages = $query->max_num_pages;

?>