<?php

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// Initial API Instance for aafran (2) - This populates the location dropdown
$locationsAPI = new API(2);

// Grab all of our offices
$locations = $locationsAPI->getFranchisees();

// SET WP NEAR TOP TO GRAB METADATA
if(isset($_GET['postID'])){

  // Include WP
  define('WP_USE_THEMES', false);
  require($nestedLocation . '../' . 'cms/wp-load.php');

  // Sanitize Post ID
  $sanitize = new Sanitize;

  $postID = $sanitize->slugSanitizer($_GET['postID']);

  $number_of_posts = 1;
  $args = array( 
    'numberposts' => $number_of_posts,
    'category' => 2,
    'orderby' => 'date',
    'order' => 'DESC',
    'name' => $postID
  );
  
  $recent_posts = wp_get_recent_posts( $args );
  $recent_post = $recent_posts[0];

  if(empty($recent_post)) {
    header('Location: ' . $nestedLocation . 'blog/');
  }

  // Custom Data
  // Read Time
  $helper = new Helper();
  $postReadTime = $helper->calculateReadTime(apply_filters('the_content', $recent_post['post_content']));

  // foreach( $recent_posts as $recent_post ){
  //   $content = apply_filters('the_content', $recent_post['post_content']);
  //   echo '<div class="modal-content mb-5 postCards">';
  //   if ( has_post_thumbnail( $recent_post["ID"]) ) {
  //     echo '<img class="card-img-top" src="' . get_the_post_thumbnail_url($recent_post["ID"],'Medium') . '" />';
  //   }
  //   echo '<div class="modal-header bg-dark text-white text-uppercase">'. '<h5 class="text-white">' . $recent_post['post_title'] . '</h5>' . "<span><small>".$recent_post['post_date']."</small></span>" . '</div>';
  //   echo  '<div class="modal-body p-4">'. "<p>".$content."</p>" . '</div>';
  //   echo '<div class="modal-footer"> <button type="button" class="btn btn-outline-primary btn-block w-100" data-bs-dismiss="modal" aria-hidden="true">Close</button> </div>';
  //   echo '</div>';
  // }

  // var_dump($recent_posts);

} else {
  // header('Location: ' . $nestedLocation . 'blog/');
}

// Set page parameters/meta
$pageType = 0;
$pageName = 'ACPM.Blog';
$pageTitle = $recent_post['post_title'];
$pageMetaDescription = substr(get_post_meta($recent_post['ID'], '_yoast_wpseo_metadesc', true), 0, 100);;
$pageMetaKeyword = array(
  'property management office', 'blog', 'blog posts', 'articles', 'property management blog', 'how to rent your rome'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

?>