<?php

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API is no longer needed
// // API Instance
// $RMAPI = new API(2);

// // Config for franchise pages
// $configFile = file_get_contents($officeNestedLocation . "config.json");
// $config = json_decode($configFile, true);

// // Get corresponding location from location data array
// $locations = $RMAPI->getFranchisees();
// foreach($locations as $location) {
//   if($location['Name'] == $config['Name']) {
//     $locationData = $location;
//   }
// }


// Get location based on URL
$locations = new Locations;
$locationData = $locations->getLocationFromURL();

// Set page parameters/meta
$pageType = 1;
$pageName = 'Home';
$pageTitle = str_replace(" Property Management", "", $locationData['franchise_name']) . ' - ' . array_shift(explode(',', $locationData['primary_city']))  . ' Property Management';
$pageMetaDescription = str_replace(" Property Management", "", $locationData['franchise_name']) . "'s " . $locationData['primary_city'] . " property managers have the local market experience needed to rent your home. Request a free quote today!";
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['franchise_name']), $locationData['franchise_name']
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Fetch data from OfficeManager
// WARNING enable this instead of the CURL below once we are in production
$officeData = new FetchOfficeData();
$latestOfficeImage = $officeData->getLatestImageData($locationData['name'], 1);
$latestOfficeBG = $officeData->getLatestImageData($locationData['name'], 2);
$latestOfficeBio = str_replace('<h1>&nbsp;</h1>', '', $officeData->getLatestBioData($locationData['name'], 1));

// Generate list of secondary cities if available
if(!empty($locationData['secondary_cities'])) {
  // Create array from UDF
  $secondaryCities = explode(', ', $locationData['secondary_cities']);
  // Check if array was created
  // if(count($secondaryCities) <= 1) {
  //   // If count is 1 or less than try alternative format
  //   unset($secondaryCities);
  //   $secondaryCities = explode(',', $locationData['secondary_cities']);
  // }
  // Limit to 5 cities
  $secondaryCities = array_slice($secondaryCities, 0, 10);
  // Set "&" for last item.
  $last = array_pop($secondaryCities); // remove last element of array
  $last = "& " . $last; // add element to array
  $secondaryCities[] = $last; // add changed last element again
  // Append primary city to list
  $secondaryCitiesCompiled = explode(', ', $locationData['primary_city'])[0];
  // Finally add remaining cities to list
  foreach($secondaryCities as $secondaryCity) {
    $secondaryCitiesCompiled = $secondaryCitiesCompiled . ', ' . $secondaryCity;
  }
}

?>