<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);
$officeData = new FetchOfficeData();

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'Owners';
$pageTitle = $locationData['Primary City'] . " Property Owner Portal - " . str_replace(" Property Management", "", $locationData['Franchise Name']);
$pageMetaDescription = "Login to see information about your rental properties using All County Property Management's online portal for " . $locationData['Primary City'] . ' homeowners.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'owner portal', 'online portal', 'view funds', 'check funds', 'funds', 'view status', 'submit tax information', 'owner money'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);


// Get owner/resident/realtor resources
$ownerResources = $officeData->getOwnerResidentResource(0, 1, $locationData['Name']);

?>