<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'Privacy';
$pageTitle = 'Privacy Policy - ' . str_replace(" Property Management", "", $locationData['Franchise Name']) . ' in ' . $locationData['Primary City'];
$pageMetaDescription = "Please take a look at our privacy policy to see how and what data is collected.";
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'property management office', 'privacy', 'privacy policy', 'data'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

?>