<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);
$officeData = new FetchOfficeData();

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'Realtors';
$pageTitle = 'Realtors - ' . str_replace(" Property Management", "", $locationData['Franchise Name']) . ' in ' . $locationData['Primary City'];
$pageMetaDescription = 'All County is a top-rated property management company with over ' . count($locations) . ' locations nationwide. See how we partner with realtors to get best outcome.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'realtors'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Get owner/resident/realtor resources
$realtorResources = $officeData->getOwnerResidentResource(0, 3, $locationData['Name']);

?>