<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'Team';
$pageTitle = 'Our Team - ' . str_replace(" Property Management", "", $locationData['Franchise Name']) . ' in ' . $locationData['Primary City'];
$pageMetaDescription = "Meet the professional property managers looking over your rental property in " . $locationData['Primary City'] . ', ' . $states[$locationData['State']] . '.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'team', 'property managers', 'staff', 'employees'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Fetch data from OfficeManager
// WARNING enable this instead of the CURL below once we are in production
$officeData = new FetchOfficeData();
$teamMembers = $officeData->getTeamMembers($locationData['Name'], 0);

?>