
    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5 pt-4 pb-lg-5">
        <div class="row g-0 mt-n3 pt-sm-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-4">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item">About</li>
                <li class="breadcrumb-item active" aria-current="page">Contact</li>
              </ol>
            </nav>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Contact Us</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">We have multiple ways to reach us, please select an option below.</p>
              </div>
            </div>
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- Option cards -->
            <section class="container mb-5 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">

                <!-- Item-->
                <div class="col-xl-3 col-lg-4 col-md-6">
                  <div class="icon-box border-primary card card-hover h-100">
                    <div class="card-header text-center p-4 text-primary fw-bold">
                    Interested in our services?
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Speak with one of our professional property managers.</span>
                    </div>
                    <div class="card-footer">
                      <a href="<?php echo $officeNestedLocation; ?>quote/"><h3 class="h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Get a free quote</h3></a>
                    </div>
                  </div>
                </div>

                <!-- Item-->
                <div class="col-xl-3 col-lg-4 col-md-6">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header text-center p-4">
                      <i class="fi-user-check display-4 text-primary"></i>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Current residents of an All County managed home.</span>
                    </div>
                    <div class="card-footer">
                      <a href="<?php echo $officeNestedLocation; ?>residents/"><h3 class="mt-4 h4 btn btn-secondary btn-block w-100 fw-bold icon-box-title mb-0">I'm a Resident</h3></a>
                    </div>
                  </div>
                </div>

                <!-- Item-->
                <div class="col-xl-3 col-lg-4 col-md-6">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header text-center p-4">
                      <i class="fi-home display-4 text-primary"></i>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Current owners of an All County managed property.</span>
                    </div>
                    <div class="card-footer">
                      <a href="<?php echo $officeNestedLocation; ?>owners/"><h3 class="mt-4 h4 btn btn-secondary btn-block w-100 fw-bold icon-box-title mb-0">I'm an Owner</h3></a>
                    </div>
                  </div>
                </div>

                <!-- Item-->
                <div class="col-xl-3 col-lg-4 col-md-6">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header text-center p-4">
                      <i class="fi-rent display-4 text-primary"></i>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">If you are looking for a place to rent.</span>
                    </div>
                    <div class="card-footer">
                      <a href="<?php echo $officeNestedLocation; ?>available-rentals/"><h3 class="mt-4 h4 btn btn-secondary btn-block w-100 fw-bold icon-box-title mb-0">I'm looking to rent</h3></a>
                    </div>
                  </div>
                </div>

              </div>
            </section>

            <!-- Contact cards-->
            <section class="container">
              <div class="row g-4">
                <!-- Item-->
                <div class="col-md-5"><a class="icon-box card card-hover h-100" target="_blank" href="mailto:contact@<?php echo strtolower($locationData['web site url']); ?>">
                    <div class="card-body">
                      <div class="icon-box-media text-primary rounded-circle shadow-sm mb-3"><i class="fi-mail"></i></div><span class="d-block mb-1 text-body">Email us at:</span>
                      <h3 class="h4 icon-box-title mb-0 opacity-90"><?php echo strtolower($locationData['Contact Email']); ?></h3>
                    </div></a></div>
                <!-- Item-->
                <div class="col-md-4"><a class="icon-box card card-hover h-100" href="tel:<?php echo $locationData['Phone Number']; ?>">
                    <div class="card-body">
                      <div class="icon-box-media text-primary rounded-circle shadow-sm mb-3"><i class="fi-device-mobile"></i></div><span class="d-block mb-1 text-body">Call us at:</span>
                      <h3 class="h4 icon-box-title mb-0 opacity-90"><?php echo $locationData['Phone Number']; ?></h3>
                    </div></a></div>
                <!-- Item-->
                <div class="col-md-3 d-none">
                  <a class="icon-box border-primary card card-hover shadow h-100" href="<?php echo $officeNestedLocation; ?>quote/">
                    <div class="card-body">
                      <span class="h5 d-block text-center mb-1 text-black my-4 fw-bold">Interested in our services?</span>
                      <br>
                      <h3 class="h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Get a free quote</h3>
                    </div>
                  </a>
                </div>
              </div>
            </section>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

    <!-- Contact form validation -->
    <script>
      function checkContactForm() {
        // check if valid email input
        if(validateName("#firstName") & validateName("#secondName") & validateEmail("#email"), validatePhone("#phoneNumber", validateName("#message"))) {
          // // log and mark successful input
          console.log('valid entries');
          $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-danger');
          $('#invalid-alert').addClass('d-none');
          // $('#firstName, #secondName, #email, #phoneNumber, #message').addClass('bg-faded-success');
          // // submit data to ajax processor
          let dataPacketContactForm =  {};
          dataPacketContactForm['formType'] = 4;
          dataPacketContactForm['firstName'] = $('#firstName').val();
          dataPacketContactForm['secondName'] = $('#secondName').val();
          dataPacketContactForm['email'] = $('#email').val();
          dataPacketContactForm['location'] = "<?php echo $locationData['Name']; ?>";
          dataPacketContactForm['phoneNumber'] = $('#phoneNumber').val();
          dataPacketContactForm['message'] = $('#message').val();
          submitDataPacket(dataPacketContactForm);
          console.log(dataPacketContactForm);
          // trigger loader
          $(".page-loading").addClass('active');
          // wait, remove loader, and clear inputs
          setTimeout(function () {
            $(':input').val('');
            $('#success-alert').removeClass('d-none');
            $(".page-loading").removeClass('active');
            // $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-success');
            $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-danger');
          }, 1000);
        } else {
          // log and mark unsuccessful input
          console.log('invalid entries');
          $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-success');
          $('#invalid-alert').removeClass('d-none');
          $('#firstName, #secondName, #email, #phoneNumber, #message').addClass('bg-faded-danger');
        }
      }

      
      // Validators
      function validateName(inputName) {
        if($(inputName).val().length != 0){
            return 1;
        }
      }
      function validatePhone(inputPhone) {
        let PhoneNumberCell = $(inputPhone).val();
        let patternPhoneNumberCell =  /^\(?([0-9]{3})\s*\)?[-. ]?([0-9]{3})[-. ]?([0-9]{4})$/;
        if(patternPhoneNumberCell.test(PhoneNumberCell)) {
            return 1;
        }
      }
      function validateEmail(inputName) {
        let Email = $(inputName).val();
        let patternEmail = /\S+@\S+\.\S+/;
        if(patternEmail.test(Email)) {
            return 1;
        }
      }

      // Data ajax processor
      function submitDataPacket(data) {
        $.ajax({
            url: "<?php echo $nestedLocation; ?>resources/helpers/form.handler.php",
            type: "post",
            data: data ,
            success: function (response) {
              console.log(response);
            },
            error: function(jqXHR, textStatus, errorThrown) {
              console.log(textStatus, errorThrown);
            }
        });
      }
    </script>