    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Form Modal-->
      <?php include_once($nestedLocation . 'resources/layouts/modals/form.rmgc.php'); ?>

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>
      
      <!-- Page content-->

      <!-- Hero-->

      <style>
        .hero-gradient-overlay {
          background: linear-gradient(180deg, rgba(255,255,255,1) 0%, rgba(255,255,255,1) 18%, rgba(255,255,255,0.9023984593837535) 35%, rgba(255,255,255,0.7051155462184874) 100%);
          box-shadow: inset 0px -11px 8px -10px #CCC;
        }
      </style>

      <section class="pt-5 jarallax bg-light zindex-1 py-xxl-5" id="header"><span class="img-overlay bg-transparent opacity-100 hero-gradient-overlay"></span>
        <div class="jarallax-img" style="background-image: url(<?php echo $latestOfficeBG['url']; ?>); background-position: bottom center;"></div>
        <div class="content-overlay container pt-5 pb-2 px-sm-4">
          <div class="row pt-4">
            <div class="col-xl-5 col-lg-6 col-md-7 mb-3 text-md-start text-center">
              <h1 class="display-4 mt-lg-3 mb-md-4 mb-3 pt-md-4 pb-lg-2" style="">
                All County <br><a class="text-primary fw-italic text-decoration-none"><?php echo str_replace('All County ', '', str_replace(' Property Management', '', $locationData['franchise_name'])); ?></a> <br>
              </h1>
              <p class="position-relative mb-md-4 mb-3 pb-lg-2 lead me-lg-n5 fw-bold">Let's rent your home today!</p>
              <p class="position-relative lead me-lg-n5">Rent your residential property hassle-free with All County. Enter your email address below to get started.</p>
              <br>
              <form class="form-group position-relative me-lg-n5 shadow-lg border-secondary" id="submit_zip" action="index.php" method="get">
                  <div class="input-group input-group-lg border-end-md"><span class="input-group-text text-muted rounded-pill ps-3"><i class="fi-map-pin mx-2"></i></span>
                    <input class="form-control is-valid" type="email" id="email" name="email" placeholder="Email address" onkeydown="return event.key != 'Enter';">
                  </div>
                  <button class="btn btn-primary btn-lg w-md-auto ms-sm-3" type="button" href="#signin-modal" data-bs-toggle="modal" data-bs-target="#rmgc" onclick="setEmailAddress();return false;">Get Started <i class="fi-arrow-right mt-0 mx-2"></i></button>
                    <script>
                    $(document).ready(function() {
                        $('.guestCardSuccessButton').click(function() {
                            $('.modal').modal('hide');
                        });
                    });
                  </script>
                </form>
            </div>
          </div>
        </div>
      </section>

      <!-- Your All County -->
      <div class="sticky-top d-none w-100 zindex-1 text-center" style="background: rgba(255, 255, 255, 0.9);top: 120px; backdrop-filter: blur(5px);">
        <p><b><i class="h4 mt-2 me-2 fi-map-pin text-primary"></i> Your All County: </b> <?php echo $locationData['Street'] . ', ' . $locationData['City'] . ', ' . $locationData['State'] . ' ' . $locationData['PostalCode']; ?> | <?php echo $locationData['Phone Number']; ?><a href="<?php echo $officeNestedLocation . 'contact/'; ?>"><button class="btn btn-primary ms-3 py-1 px-3">Get in touch <i class="ms-2 fi-arrow-right"></i></button></a></p>
      </div>
      
      <!-- Features-->
      <section class="container mb-5 mt-5 pb-lg-5" id="info">
        <div class="">
          <h2 class="h2 mb-1">Residential Property Management in <?php echo $locationData['Primary City']; ?></h5>
          <?php if(isset($secondaryCities)) { $long ?>
          <h5 class="text-accent">Serving <?php echo $secondaryCitiesCompiled; ?>.</h5>
          <?php } else { ?>
          <h5 class="text-accent">Serving <?php echo $locationData['Primary City']; ?> & surrounding areas.</h5>
          <?php } ?>
          <hr>
        </div>
        <div class="row mt-5">
          <div class="col-lg-6 col-md-7 mt-4">
                <h5 class="h5 mb-0">We're a full-service property management company.</h5>
                <br>
                <p>At All County <?php echo str_replace('All County ', '', str_replace(' Property Management', '', $locationData['Franchise Name'])); ?>, you get the best return on your property investment. We’ll help you avoid problems that could cost you money down the road. We understand just how important your real-estate investment is to your financial well-being. That is exactly why we focus exclusively on residential property management and nothing else.</p>
                <br>
                <a class="btn btn-lg btn-primary" href="<?php $officeNestedLocation; ?>about/">Learn more</a>
          </div>
          <div class="col-md-5 offset-lg-1 mt-4">
            <h5 class="h5 mb-0">We provide property owners the following benefits:</h5>
                <br>
                <div class="row">
                  <div class="mt-2">
                    <a class="btn btn-icon btn-primary text-white btn-xs shadow-sm rounded-circle ms-2 float-left"><i class="fi-check"></i></a>
                    <a class="h6 fw-normal ms-2 float-right text-decoration-none">Maximized Rental Property Revenue</a>
                  </div>
                  <div class="mt-2">
                    <a class="btn btn-icon btn-primary text-white btn-xs shadow-sm rounded-circle ms-2 float-left"><i class="fi-check"></i></a>
                    <a class="h6 fw-normal ms-2 float-right text-decoration-none">Maintained Rental Property</a>
                  </div>
                  <div class="mt-2">
                    <a class="btn btn-icon btn-primary text-white btn-xs shadow-sm rounded-circle ms-2 float-left"><i class="fi-check"></i></a>
                    <a class="h6 fw-normal ms-2 float-right text-decoration-none">Avoidance of Costly Mistakes</a>
                  </div>
                  <div class="mt-2">
                    <a class="btn btn-icon btn-primary text-white btn-xs shadow-sm rounded-circle ms-2 float-left"><i class="fi-check"></i></a>
                    <a class="h6 fw-normal ms-2 float-right text-decoration-none">Managed Tenant Relationships</a>
                  </div>
                  <div class="mt-2">
                    <a class="btn btn-icon btn-primary text-white btn-xs shadow-sm rounded-circle ms-2 float-left"><i class="fi-check"></i></a>
                    <a class="h6 fw-normal ms-2 float-right text-decoration-none">Tracked Income & Expenses</a>
                  </div>
                  <div class="mt-2">
                    <a class="btn btn-icon btn-primary text-white btn-xs shadow-sm rounded-circle ms-2 float-left"><i class="fi-check"></i></a>
                    <a class="h6 fw-normal ms-2 float-right text-decoration-none">Simple and Transparent Fees</a>
                  </div>
                </div>
          </div>
        </div>
      </section>

      <!-- What we do best -->
      <section class="container mb-5 mt-5 pb-lg-5 pb-2 pb-sm-3" id="what-we-do-best">
        <h2 class="mb-1">What we do best.</h2>
        <h5 class="mb-2 text-accent">Our expertise makes it easy.</h5>
        <div class="row gy-4 mt-4">
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch pe-lg-4">
            <div class="card">
              <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/residential-property-management.jpg" alt="Property manager presenting documents to clients.">
              <div class="card-header text-center text-primary pb-0">
                <h6>Residential Property Management</h6>
              </div>
              <div class="card-body">
                <p class="mb-1 pb-md-3 opacity-70">
                  We believe in doing one thing and doing it right, and we specialize in Residential Property Management. ``We Rent Homes!``
                </p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch pe-lg-4">
            <div class="card">
              <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/outstanding-communication.jpg" alt="Two individuals discussing.">
              <div class="card-header text-center text-primary pb-0">
                <h6>Outstanding Communication</h6>
              </div>
              <div class="card-body">
                <p class="mb-1 pb-md-3 opacity-70">
                  We go out of our way to make sure that you are always informed about the status of your property. You get to decide how often you hear from us.
                </p>
              </div>
            </div>
          </div>
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch">
            <div class="card">
              <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/transparent-pricing.jpg" alt="Man with blue shirt stacking coins.">
              <div class="card-header text-center text-primary pb-0">
                <h6>Transparent Pricing</h6>
              </div>
              <div class="card-body">
                <p class="mb-1 pb-md-3 opacity-70">
                  Our fee structure is pretty straightforward. We make money when you make money, and we don't up charge for maintenance.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Why choose us -->
      <section class="container mb-5 mt-5 pb-lg-5 pb-2 pb-sm-3" id="whyus">
        <h2 class="mb-1">Why partner with us?</h2>
        <h5 class="mb-2 text-accent">See why it just makes sense.</h5>
        <div class="row gy-4 align-items-lg-center">
          <div class="col-md-6 pe-4 pt-5 pb-5">
            <img class="rounded-3" src="<?php echo $nestedLocation; ?>resources/img/property-management/roi.jpg" alt="Man wearing a mask and holding a tablet smiling.">
          </div>
          <div class="col-lg-5 offset-lg-1 col-md-6 text-md-start text-center">
            <h4 class="mb-md-4">Get a better return on investment</h4>
            <p class="mb-4 pb-md-3 opacity-70">
              Real-Estate investment is all about the long-term payoff. If you have a rental property then you want to be sure you are making as much money as you could from it.
              <br><br>
              Our experts evaluate your property to get you the best rental rates for your property. We place quality tenants that will take care of the property, and we know all of the rules and regulations you need to comply with so that you avoid costly legal issues in the future.
            </p>
            <a class="btn btn-primary w-sm-auto w-100" href="<?php echo $officeNestedLocation . '#header' ;?>">Get in touch <i class="ms-2 fi-arrow-right"></i></a>
          </div>
        </div>
        <div class="row gy-4 align-items-lg-center">
          <div class="col-lg-5 col-md-6 order-md-1 order-2 text-md-start text-center">
            <h4 class="mb-md-4">Effective & transparent property management</h4>
            <p class="mb-4 pb-md-3 opacity-70">
              All County has been improving and refining our property management practices since 1990. We are clear and upfront about our fees, and we will never charge you for maintenance.
              <br><br>
              Our property managers will always go above and beyond your expectations to make sure that your property is cared for, and that you know exactly what is going on with your property at any given moment.
            </p>
            <a class="btn btn-primary w-sm-auto w-100" href="<?php echo $officeNestedLocation . '#header' ;?>">Get in touch <i class="ms-2 fi-arrow-right"></i></a>
          </div>
          <div class="col-md-6 offset-lg-1 order-md-2 order-1  ps-4 pt-5 pb-5">
            <img class="rounded-3" src="<?php echo $nestedLocation; ?>resources/img/property-management/effective-transparent-management.jpg" alt="Two business professionals high fiving in front of a desk.">
          </div>
        </div>
        <div class="row gy-4 align-items-lg-center">
          <div class="col-md-6  pe-4 pt-5 pb-5">
            <img class="rounded-3" src="<?php echo $nestedLocation; ?>resources/img/property-management/knowledgeable-professionals.jpg" alt="Mand and woman shacking hands in a office building.">
          </div>
          <div class="col-lg-5 offset-lg-1 col-md-6 text-md-start text-center">
            <h4 class="mb-md-4">Get paired with a knowledgeable professional</h4>
            <p class="mb-4 pb-md-3 opacity-70">
            If you really want to make the most money from your property in the long run then hiring a property manager is a must. When you hire All County to manage your property you get paired with a knowledgeable property management expert to help you maximize your ROI while avoiding the headaches of trying to do it yourself.
            </p>
            <a class="btn btn-primary w-sm-auto w-100" href="<?php echo $officeNestedLocation . '#header' ;?>">Get in touch <i class="ms-2 fi-arrow-right"></i></a>
          </div>
        </div>
      </section>

      <!-- Testimonials-->
      <?php
        // Testimonials
        if(!empty($locationData['ReviewDBOverride'])) {
          $review_location = $locationData['ReviewDBOverride'];
        } else {
          $review_location = $locationData['Name'];
        }
        $testimonials = new Testimonials($review_location);
        // Quantity, Minimum Rating, Minimum Word Count
        $getTestimonials = $testimonials->getTestimonials(4, 10);
      ?>
      <section class="container mb-5 pb-md-4" id="testimonials">
        <div class="d-flex align-items-center justify-content-between mb-1">
          <h2 class="mb-0">Testimonials</h2><a class="btn btn-link fw-normal p-0" href="<?php echo $officeNestedLocation . 'reviews/' ;?>">View all testimonials<i class="fi-arrow-long-right ms-2"></i></a>
        </div>
        <h5 class="mb-4 text-accent">See what people say about us</h5>
        <div class="tns-carousel-wrapper tns-controls-outside-xxl tns-nav-outside tns-nav-outside-flush mx-n2">
          <div class="tns-carousel-inner row gx-4 mx-0 pt-3 pb-4" data-carousel-options="{&quot;items&quot;: 4, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:2},&quot;768&quot;:{&quot;items&quot;:3},&quot;992&quot;:{&quot;items&quot;:4}}}">
            <?php if(!$getTestimonials) { echo '<p>No testimonials available, please check back later.</p>'; } else { foreach($getTestimonials as $testimonial) { ?>

                  <!-- Item-->
                  <div class="col">
                    <div class="card border-0 shadow-sm">
                      <blockquote class="blockquote card-body">
                        <p class="font-italic">"<?php echo preg_replace('/((\w+\W*){'.(30-1).'}(\w+))(.*)/', '${1}', trim($testimonial['content'])); ?>..."</p>
                        <footer class="d-flex justify-content-between">
                          <div class="pe-3">
                            <h6 class="mb-0"><?php echo $testimonial['author'] ; ?></h6>
                          </div>
                        </footer>
                      </blockquote>
                    </div>
                  </div>
            <?php } } ?>
          </div>
        </div>
      </section>

      <?php if (!isset($locationData['ShowMojo ID'])) { ?>
      <!-- Available rentals-->
      <?php
        // Add tenant turner API info
        // don't call the Tenant Turner API unless we have an ID to give it.
        if(isset($locationData['TenantTurnerPhone'])) {
          // $tenantTurnerAccountID = $locationData['TenantTurnerID'];
          $tenantTurnerAPI = new TenantTurner();
          // getListings() accepts numeric values, enter 0 to get all
          $listings = $tenantTurnerAPI->getListings(NULL, '1' . $locationData['TenantTurnerPhone']);
          $listings = array_slice($listings, 0, 8);
          // var_dump($listings);
        }
      ?>
      <section class="container mb-5 pb-md-4" id="availablerentals">
        <div class="d-flex align-items-center justify-content-between mb-1">
          <h2 class="mb-0">Available Rentals</h2><a class="btn btn-link fw-normal p-0" href="<?php echo $officeNestedLocation . 'available-rentals/' ;?>">View all rentals<i class="fi-arrow-long-right ms-2"></i></a>
        </div>
        <h5 class="mb-4 text-accent">See what's available for rent</h5>
        <div class="tns-carousel-wrapper tns-controls-outside-xxl tns-nav-outside tns-nav-outside-flush mx-n2">
          <div class="tns-carousel-inner row gx-4 mx-0 pt-3 pb-4" data-carousel-options="{&quot;items&quot;: 4, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:2},&quot;768&quot;:{&quot;items&quot;:3},&quot;992&quot;:{&quot;items&quot;:4}}}">
            <?php 
            if(!isset($listings)) { echo '<p>No listings available, please check back later.</p>'; } 
            // spit out only 5 listings
            else { foreach($listings as $listing) { ?>
              <!-- Item-->
              <div class="col">
                <div class="card shadow-sm card-hover border-0 h-100">
                  <div class="card-img-top card-img-hover"><a class="img-overlay" href="available-rentals/listing/?id=<?php echo $listing['id']; ?>"></a>
                    <div class="img-responsive listing-image-preview" style="background-image: url('<?php echo $listing['photos'][0]; ?>'); height: 200px;"></div>
                  </div>
                  <div class="card-body position-relative pb-3">
                    <h4 class="mb-1 fs-xs fw-normal text-uppercase text-primary">For rent</h4>
                    <h3 class="h6 mb-2 fs-base"><a class="nav-link stretched-link" href="available-rentals/listing/?id=<?php echo $listing['id']; ?>"><?php echo $listing['propertyType']; ?></a></h3>
                    <p class="mb-2 fs-sm text-muted"><?php echo $listing['address']; ?></p>
                    <?php if(!empty($listing['city']) || !empty($listing['state']) || !empty($listing['zip'])) { ?>
                    <p class="mb-2 fs-sm text-muted"><?php echo $listing['city'] . ', ' . $listing['state'] . ' ' . substr($listing['zip'], 0, 5); ?></p>
                    <?php } ?>
                    <p class="mb-2 fs-sm text-muted">Avaibility: <?php if (strtotime($listing['dateAvailable']) < time()) { echo 'Now'; } else { echo $listing['dateAvailable']; } ?></p>
                    <div class="d-flex align-items-center justify-content-center mx-3 pt-2 text-nowrap">
                      <span class="d-inline-block mx-1 px-2 fs-sm"><i class="fi-bed me-1 mt-n1 fs-lg text-primary"></i><?php echo $listing['beds']; ?> Beds</span>
                      <span class="d-inline-block mx-1 px-2 fs-sm"><i class="fi-bath me-1 mt-n1 fs-lg text-primary"></i><?php echo $listing['baths']; ?> Baths</span>
                    </div>
                    <div class="d-flex align-items-center justify-content-center mx-3 pt-3 pb-2 text-nowrap">
                      <div class="fw-bold fs-sm"><i class="fi-cash mt-n1 me-2 lead align-middle fs-lg text-primary"></i>Rent: $<?php echo $listing['rentAmount']; ?></div>
                    </div>
                  </div>
                </div>
              </div>
            <?php } } ?>
          </div>
        </div>
      </section>
      <?php } ?>


      <!-- Our story-->
      <section class="container mb-5 pb-lg-4 pb-md-4" id="ourstory">
        <h2 class="mb-1">Our story</h2>
        <h5 class="mb-5 text-accent">Learn about who we are</h5>
        <?php include_once($nestedLocation . 'resources/layouts/franchise/components/story-photo.layout.php'); ?>
      </section>

      <?php if($locationData['State'] == 'CO') { ?>
      <section class="container mb-5 pb-lg-4 pb-md-4" id="CODisclosure">
        <h2 class="mb-4">Disclosures</h2>
          <div class="card py-3 bg-secondary">
            <div class="card-body">
              <b><h4>PTSR Disclosure</h4></b>
              <p>Applicant has the right to provide All County Property Management with a Portable Tenant Screening Report (PTSR) that is not more than 30 days old, as defined in 38-12-902(2.5), Colorado Revised Statutes; and 2) if Applicant provides All County Property Management with a PTSR, All County Property Management is prohibited from: a) charging Applicant a rental application fee; or b) charging Applicant a fee for All County Property Management to access or use the PTSR.</p>
              <br>
              <b><h4>Radon Disclosure</h4></b>
              <p>The Colorado Department of Public Health and Environment strongly recommends that all home buyers have an indoor radon test performed before purchasing residential real property and recommends having the radon levels mitigated if elevated radon concentrations are found. Elevated radon concentrations can be reduced by a radon mitigation professional. Residential real property may present exposure to dangerous levels of indoor radon gas that may place the occupants at risk of developing radon-induced lung cancer. Radon, a Class A human carcinogen, is the leading cause of lung cancer in nonsmokers and the second leading cause of lung cancer overall. the seller of residential real property is required to provide the buyer with any known information on radon test results of the residential real property.</p>
            </div>
             </div>
      </section>
      <?php } ?>
      
    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>
