
  <?php
    // Testimonials
    if(!empty($locationData['ReviewDBOverride'])) {
      $review_location = $locationData['ReviewDBOverride'];
    } else {
      $review_location = $locationData['Name'];
    }
    $testimonials = new Testimonials($review_location);
    // Quantity, Minimum Rating, Minimum Word Count
    $getTestimonials = $testimonials->getTestimonials(5, 10);

    // // Generate two testimonial hash's to get daily unique reviews for offices that don't have custom reviews, two because it may not contain enough numbers to get us what we need
    // $testimonialsHash = preg_replace("/[^0-9]/", "",md5($locationData['Name'] . ' - ' . date('m-d-y'))) . preg_replace("/[^0-9]/", "",md5($locationData['Name'] . ' - ' . date('m-d-y') . ' Two'));
    // $reviewIDArr = [];
    // $positionNum = 1;
    // $regenAttempts = 0;
    // // Generate 5 unique number review id number pairs
    // for($i = 1; $i < 6; $i++) {
    //   $numberPair = substr($testimonialsHash, ($positionNum * 2 - 2), 2);
    //   while(in_array($numberPair, $reviewIDArr) || $numberPair == 00 && $regenAttempts < 10) {
    //     $positionNum++;
    //     $regenAttempts++;
    //     $numberPair = substr($testimonialsHash, ($positionNum * 2 - 2), 2);
    //   }
    //   if($numberPair) {
    //     array_push($reviewIDArr, $numberPair);
    //   }
    //   $positionNum++;
    // }

  ?>

  <!-- Page loading spinner-->
  <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->
      <!-- Page container-->
      <div class="container my-5 pb-lg-5">
        <div class="row g-0 mt-n3 pt-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-5">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Testimonials</li>
              </ol>
            </nav>
            <!-- Title-->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Testimonials</h1>
            </div>
            <div class="row mb-3">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Take a look at what people are saying about All County.</p>
              </div>
            </div>
            <!-- Sorting-->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
              <div class="d-none d-sm-flex align-items-center flex-shrink-0 text-muted"><i class="fi-check-circle me-2"></i><span class="fs-sm mt-n1"><?php if(!is_array($getTestimonials)) { echo '0'; } else { if(count($getTestimonials) == 100) { echo '100+'; } else { echo count($getTestimonials); } } ?> Testimonials</span></div>
            </div>

            <!-- Testimonial grid-->
            <div class="row g-4 py-4">
              <div class="card-columns-3">
                <?php
                if(!$getTestimonials) { echo '<p>No testimonials available, please check back later.</p>'; } else {
                  foreach($getTestimonials as $testimonial) { ?>
                  <div class="card shadow-sm mb-4 rounded" style="border: 1px solid #e5e5e5;">
                    <div class="card-body pb-1">
                      <div class="d-flex justify-content-between">
                        <div class="d-flex align-items-center pe-2">
                          <div class="ps-2">
                            <h6 class="fs-base mb-0"><?php echo $testimonial['author'] ; ?></h6>
                          </div>
                        </div>
                        <span class="text-muted fs-sm"></span>
                      </div>
                      <p class="text-center mt-3"><?php echo $testimonial['content']; ?></p>
                    </div>
                  </div>
                <?php } } ?>
              </div>
            </div>

          </div>
        </div>
      </div>
    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/leaflet/dist/leaflet.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>