<?php

// Pre-requisites
$nestedLocation = '../../';
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
$pageTitle = 'Template Page';
$pageName = 'Template';
$pageType = 0;

// Auto load classes
include($nestedLocation . 'resources/includes/class-autoload.inc.php');

// Initial API Instance for aafran (2) - This populates the location dropdown
$locationsAPI = new API(2);

// Grab all of our offices
$locations = $locationsAPI->getFranchisees();

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title><?php echo $pageTitle; ?></title>
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>

    <script>
      (function () {
        window.onload = function () {
          var preloader = document.querySelector('.page-loading');
          preloader.classList.remove('active');
          setTimeout(function () {
            preloader.remove();
          }, 2000);
        };
      })();
    </script>
    
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Sign In Modal-->
      <?php include_once($nestedLocation . 'resources/layouts/sign-in-modal.layout.php'); ?>

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->

      <!-- Property cost calculator modal-->
      <?php include_once($nestedLocation . 'resources/layouts/modals/calculator.layout.php'); ?>

      <!-- Rent my home modal-->
      <?php include_once($nestedLocation . 'resources/layouts/modals/rmh.layout.php'); ?>

      <!-- Hero-->
      <section class="container-fluid bg-services">
        <section class="container mb-5 pb-2 pt-5 pb-5 service-bg">
          <div class="row align-items-center justify-content-center pt-5 pb-5">
            <!-- Hero content-->
            <div class="col-lg-5 col-md-5 col-sm-9 order-md-1 order-2 text-md-start text-center pt-5">
              <h1 class="mb-4 display-4">Our Property Management Services</h1>
              <p class="mb-4 pb-3 fs-lg">We provide a complete service for the sale, purchase or rental of real estate. We have been operating more than 10 years. Search millions of apartments and houses on Finder.</p>
              <a class="btn btn-lg btn-primary rounded-pill me-3" href="real-estate-contacts.html">Find an office</a>
              <!-- <a class="btn btn-lg btn-secondary rounded-pill" href="real-estate-contacts.html">Learn more</a> -->
            </div>
            <!-- Hero carousel-->
            <div class="col-lg-6 col-md-6 offset-md-1 col-12 order-md-2 order-1 pt-5">
              <img class="pt-5" src="<?php echo $nestedLocation; ?>resources/img/signin-modal/signin.svg" alt="Hero image">
            </div>
          </div>
        </section>
      </section>

      <!-- CTA-->
      <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>
  </body>
</html>